/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.ArrayIterator;
import com.btk5h.skriptmirror.Util;
import com.btk5h.skriptmirror.skript.custom.CustomCondition;
import com.btk5h.skriptmirror.skript.custom.CustomEffect;
import com.btk5h.skriptmirror.skript.custom.CustomExpression;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxEvent;
import java.util.Iterator;
import java.util.regex.MatchResult;
import org.bukkit.event.Event;

public class ExprExpression<T>
implements Expression<T> {
    private int index;
    private boolean plural;
    private final ExprExpression<?> source;
    private final Class<? extends T>[] types;
    private final Class<T> superType;

    public ExprExpression() {
        this(null, Object.class);
    }

    @SafeVarargs
    private ExprExpression(ExprExpression<?> source, Class<? extends T> ... types) {
        if (source != null) {
            this.index = source.index;
            this.plural = source.plural;
        }
        this.source = source;
        this.types = types;
        this.superType = Utils.getSuperType((Class[])types);
    }

    public T getSingle(Event e) {
        T[] all = this.getAll(e);
        if (all.length == 0) {
            return null;
        }
        return all[0];
    }

    public T[] getArray(Event e) {
        return this.getAll(e);
    }

    public T[] getAll(Event e) {
        Expression<?> expr = this.getExpression(e);
        if (expr == null) {
            return Util.newArray(this.superType, 0);
        }
        return Converters.convertArray((Object[])expr.getAll(e), (Class[])this.types, this.superType);
    }

    Expression<?> getExpression(Event e) {
        Expression<?>[] expressions = ((CustomSyntaxEvent)e).getExpressions();
        if (this.index < expressions.length) {
            return expressions[this.index];
        }
        return null;
    }

    public boolean isSingle() {
        return !this.plural;
    }

    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return SimpleExpression.check((Object[])this.getAll(e), c, (boolean)negated, (boolean)this.getAnd());
    }

    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check((Object[])this.getAll(e), c, (boolean)false, (boolean)this.getAnd());
    }

    public <R> Expression<? extends R> getConvertedExpression(Class<R>[] to) {
        return new ExprExpression<R>(this, to);
    }

    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    public boolean getAnd() {
        return true;
    }

    public boolean setTime(int time) {
        return false;
    }

    public int getTime() {
        return 0;
    }

    public boolean isDefault() {
        return false;
    }

    public Iterator<? extends T> iterator(Event e) {
        return new ArrayIterator((Object[])this.getAll(e));
    }

    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("expression");
    }

    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    public Expression<? extends T> simplify() {
        return this;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        throw new UnsupportedOperationException();
    }

    public String toString(Event e, boolean debug) {
        return "expression " + (this.index + 1);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent((Class[])new Class[]{CustomEffect.EffectEvent.class, CustomExpression.ExpressionGetEvent.class, CustomExpression.ExpressionChangeEvent.class, CustomCondition.ConditionEvent.class})) {
            Skript.error((String)"The expression 'expression' may only be used in a custom syntax.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.index = Utils.parseInt((String)((MatchResult)parseResult.regexes.get(0)).group(1));
        if (this.index <= 0) {
            Skript.error((String)"The expression index must be a natural number.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        --this.index;
        this.plural = parseResult.mark == 1;
        return true;
    }

    static {
        Skript.registerExpression(ExprExpression.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] expr[ession][(1\u00a6s)](-| )<(\\d+)>"});
    }
}

