/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.ArrayIterator;
import com.btk5h.skriptmirror.Util;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.regex.MatchResult;
import java.util.stream.StreamSupport;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class CustomExpression {
    private static SyntaxElementInfo<?> thisInfo;
    private static List<String> expressions;
    private static Map<String, SyntaxInfo> expressionInfos;
    private static Map<SyntaxInfo, Trigger> expressionHandlers;
    private static Map<SyntaxInfo, Trigger> changerHandlers;

    private static void updateExpressions() {
        Util.setPatterns(thisInfo, expressions.toArray(new String[0]));
    }

    private static SyntaxInfo createSyntaxInfo(String pattern, boolean alwaysPlural, boolean adaptArgument) {
        StringBuilder newPattern = new StringBuilder(pattern.length());
        ArrayList<Integer> inheritedSingles = new ArrayList<Integer>();
        String[] parts = pattern.split("%");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            if (i2 % 2 == 0) {
                newPattern.append(part);
                continue;
            }
            if (part.startsWith("$")) {
                part = part.substring(1);
                inheritedSingles.add(i2 / 2);
            }
            if (part.startsWith("_")) {
                part = part.endsWith("s") ? "objects" : "object";
            }
            newPattern.append('%');
            newPattern.append(part);
            newPattern.append('%');
        }
        return new SyntaxInfo(newPattern.toString(), inheritedSingles.stream().mapToInt(i -> i).toArray(), alwaysPlural, adaptArgument);
    }

    static {
        Skript.registerEvent((String)"*Define Expression", EventHandler.class, (Class[])new Class[]{ExpressionGetEvent.class, ExpressionChangeEvent.class}, (String[])new String[]{"(get|1\u00a6change) [(2\u00a6(plural|non(-|[ ])single|multi[ple]))] expression <.+>", "(get|1\u00a6change) [(2\u00a6(plural|non(-|[ ])single|multi[ple]))] %*classinfo% property <.+>"});
        Skript.registerExpression(ExpressionHandler.class, Object.class, (ExpressionType)ExpressionType.PATTERN_MATCHES_EVERYTHING, (String[])new String[0]);
        Optional<ExpressionInfo> info = StreamSupport.stream(Spliterators.spliteratorUnknownSize(Skript.getExpressions(), 16), false).filter(i -> i.c == ExpressionHandler.class).findFirst();
        if (info.isPresent()) {
            thisInfo = (SyntaxElementInfo)info.get();
        } else {
            Skript.warning((String)"Could not find custom expression class. Custom expressions will not work.");
        }
        expressions = new ArrayList<String>();
        expressionInfos = new HashMap<String, SyntaxInfo>();
        expressionHandlers = new HashMap<SyntaxInfo, Trigger>();
        changerHandlers = new HashMap<SyntaxInfo, Trigger>();
    }

    public static class ExpressionHandler<T>
    implements Expression<T> {
        private SyntaxInfo which;
        private Expression<?>[] exprs;
        private SkriptParser.ParseResult parseResult;
        private final ExpressionHandler<?> source;
        private final Class<? extends T>[] types;
        private final Class<T> superType;

        public ExpressionHandler() {
            this(null, Object.class);
        }

        @SafeVarargs
        private ExpressionHandler(ExpressionHandler<?> source, Class<? extends T> ... types) {
            this.source = source;
            if (source != null) {
                this.which = source.which;
                this.exprs = source.exprs;
                this.parseResult = source.parseResult;
            }
            this.types = types;
            this.superType = Utils.getSuperType((Class[])types);
        }

        public T getSingle(Event e) {
            T[] all = this.getAll(e);
            return all.length == 0 ? null : (T)all[0];
        }

        public T[] getArray(Event e) {
            return this.getAll(e);
        }

        public T[] getAll(Event e) {
            Trigger trigger = (Trigger)expressionHandlers.get(this.which);
            ExpressionGetEvent expressionEvent = new ExpressionGetEvent(e, this.exprs, this.parseResult);
            if (trigger == null) {
                Skript.error((String)String.format("The custom expression '%s' no longer has a get handler.", this.which.getPattern()));
                return Util.newArray(this.superType, 0);
            }
            trigger.execute((Event)expressionEvent);
            if (expressionEvent.getOutput() == null) {
                Skript.error((String)String.format("The get handler for '%s' did not continue.", this.which.getPattern()));
                return Util.newArray(this.superType, 0);
            }
            return Converters.convertArray((Object[])expressionEvent.getOutput(), (Class[])this.types, this.superType);
        }

        public boolean isSingle() {
            return !this.which.isAlwaysPlural() && Arrays.stream(this.which.getInheritedSingles()).mapToObj(i -> this.exprs[i]).filter(Objects::nonNull).allMatch(Expression::isSingle);
        }

        public boolean check(Event e, Checker<? super T> c, boolean negated) {
            return SimpleExpression.check((Object[])this.getAll(e), c, (boolean)negated, (boolean)this.getAnd());
        }

        public boolean check(Event e, Checker<? super T> c) {
            return SimpleExpression.check((Object[])this.getAll(e), c, (boolean)false, (boolean)this.getAnd());
        }

        public <R> Expression<? extends R> getConvertedExpression(Class<R>[] to) {
            return new ExpressionHandler<R>(this, to);
        }

        public Class<T> getReturnType() {
            return this.superType;
        }

        public boolean getAnd() {
            return true;
        }

        public boolean setTime(int time) {
            return false;
        }

        public int getTime() {
            return 0;
        }

        public boolean isDefault() {
            return false;
        }

        public Iterator<? extends T> iterator(Event e) {
            return new ArrayIterator((Object[])this.getAll(e));
        }

        public boolean isLoopOf(String s) {
            return false;
        }

        public Expression<?> getSource() {
            return this.source == null ? this : this.source;
        }

        public Expression<? extends T> simplify() {
            return this;
        }

        public String toString(Event e, boolean debug) {
            return this.which.getPattern();
        }

        public String toString() {
            return this.toString(null, false);
        }

        public Class<?>[] acceptChange(Changer.ChangeMode mode) {
            Class[] classArray;
            if (changerHandlers.containsKey(this.which)) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Object[].class;
            } else {
                classArray = null;
            }
            return classArray;
        }

        public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
            Trigger trigger = (Trigger)changerHandlers.get(this.which);
            ExpressionChangeEvent expressionEvent = new ExpressionChangeEvent(e, this.exprs, this.parseResult, delta, mode);
            if (trigger == null) {
                Skript.error((String)String.format("The custom expression '%s' no longer has a change handler.", this.which.getPattern()));
            } else {
                trigger.execute((Event)expressionEvent);
            }
        }

        public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
            String pattern = (String)expressions.get(matchedPattern);
            this.which = (SyntaxInfo)expressionInfos.get(pattern);
            if (this.which.shouldAdaptArgument()) {
                Expression<?> lastExpression = exprs[exprs.length - 1];
                System.arraycopy(exprs, 0, exprs, 1, exprs.length - 1);
                exprs[0] = lastExpression;
            }
            this.exprs = (Expression[])Arrays.stream(exprs).map(Util::defendExpression).toArray(Expression[]::new);
            this.parseResult = parseResult;
            return Util.canInitSafely(this.exprs);
        }
    }

    public static class EventHandler
    extends SelfRegisteringSkriptEvent {
        private List<SyntaxInfo> whiches = new ArrayList<SyntaxInfo>();
        private boolean isChanger;

        public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
            this.isChanger = (parseResult.mark & 1) == 1;
            String what = ((MatchResult)parseResult.regexes.get(0)).group();
            switch (matchedPattern) {
                case 0: {
                    this.whiches.add(CustomExpression.createSyntaxInfo(what, (parseResult.mark & 2) == 2, false));
                    break;
                }
                case 1: {
                    String fromType = ((ClassInfo)args[0].getSingle()).getCodeName();
                    this.whiches.add(CustomExpression.createSyntaxInfo("[the] " + what + " of %$" + fromType + "s%", false, true));
                    this.whiches.add(CustomExpression.createSyntaxInfo("%$" + fromType + "s%'[s] " + what, false, false));
                }
            }
            return true;
        }

        public void register(Trigger t) {
            this.whiches.forEach(which -> {
                Map handlerMap;
                String pattern = which.getPattern();
                if (!expressions.contains(pattern)) {
                    expressions.add(pattern);
                    expressionInfos.put(pattern, which);
                }
                Map map = handlerMap = this.isChanger ? changerHandlers : expressionHandlers;
                if (handlerMap.containsKey(which)) {
                    Skript.error((String)String.format("The custom expression '%s' already has a handler.", pattern));
                } else {
                    handlerMap.put(which, t);
                }
            });
            CustomExpression.updateExpressions();
        }

        public void unregister(Trigger t) {
            this.whiches.forEach(which -> {
                Map handlerMap = this.isChanger ? changerHandlers : expressionHandlers;
                handlerMap.remove(which);
                if (!expressionHandlers.containsKey(which) && !changerHandlers.containsKey(which)) {
                    expressions.remove(which.getPattern());
                    expressionInfos.remove(which.getPattern());
                }
            });
            CustomExpression.updateExpressions();
        }

        public void unregisterAll() {
            expressions.clear();
            expressionInfos.clear();
            expressionHandlers.clear();
            changerHandlers.clear();
            CustomExpression.updateExpressions();
        }

        public String toString(Event e, boolean debug) {
            return "expression: " + this.whiches.toString();
        }
    }

    public static class ExpressionChangeEvent
    extends CustomSyntaxEvent {
        private static final HandlerList handlers = new HandlerList();
        private final Object[] delta;
        private final Changer.ChangeMode mode;

        public ExpressionChangeEvent(Event event, Expression<?>[] expressions, SkriptParser.ParseResult parseResult, Object[] delta, Changer.ChangeMode mode) {
            super(event, expressions, parseResult);
            this.delta = delta;
            this.mode = mode;
        }

        public static HandlerList getHandlerList() {
            return handlers;
        }

        public Object[] getDelta() {
            return this.delta;
        }

        public Changer.ChangeMode getMode() {
            return this.mode;
        }

        public HandlerList getHandlers() {
            return handlers;
        }
    }

    public static class ExpressionGetEvent
    extends CustomSyntaxEvent {
        private static final HandlerList handlers = new HandlerList();
        private Object[] output;

        public ExpressionGetEvent(Event event, Expression<?>[] expressions, SkriptParser.ParseResult parseResult) {
            super(event, expressions, parseResult);
        }

        public static HandlerList getHandlerList() {
            return handlers;
        }

        public Object[] getOutput() {
            return this.output;
        }

        public void setOutput(Object[] output) {
            this.output = output;
        }

        public HandlerList getHandlers() {
            return handlers;
        }
    }

    private static class SyntaxInfo {
        private final String pattern;
        private final int[] inheritedSingles;
        private final boolean alwaysPlural;
        private final boolean adaptArgument;

        private SyntaxInfo(String pattern, int[] inheritedSingles, boolean alwaysPlural, boolean adaptArgument) {
            this.pattern = pattern;
            this.inheritedSingles = inheritedSingles;
            this.alwaysPlural = alwaysPlural;
            this.adaptArgument = adaptArgument;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int[] getInheritedSingles() {
            return this.inheritedSingles;
        }

        public boolean isAlwaysPlural() {
            return this.alwaysPlural;
        }

        public boolean shouldAdaptArgument() {
            return this.adaptArgument;
        }

        public String toString() {
            return String.format("%s (singles: %s, plural: %s, adapt: %s)", this.pattern, Arrays.toString(this.inheritedSingles), this.alwaysPlural, this.adaptArgument);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SyntaxInfo that = (SyntaxInfo)o;
            return this.alwaysPlural == that.alwaysPlural && this.adaptArgument == that.adaptArgument && Objects.equals(this.pattern, that.pattern) && Arrays.equals(this.inheritedSingles, that.inheritedSingles);
        }

        public int hashCode() {
            int result = Objects.hash(this.pattern, this.alwaysPlural, this.adaptArgument);
            result = 31 * result + Arrays.hashCode(this.inheritedSingles);
            return result;
        }
    }
}

