/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.ArrayIterator;
import com.btk5h.skriptmirror.Descriptor;
import com.btk5h.skriptmirror.JavaType;
import com.btk5h.skriptmirror.LRUCache;
import com.btk5h.skriptmirror.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.event.Event;

public class ExprJavaCall<T>
implements Expression<T> {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final Object[] NO_ARGS = new Object[0];
    private static final Descriptor CONSTRUCTOR_DESCRIPTOR = Descriptor.create("<init>");
    private static final Map<Class<?>, Class<?>> WRAPPER_CLASSES = new HashMap();
    private static final Set<Class<?>> NUMERIC_CLASSES = new HashSet();
    private LRUCache<Descriptor, Collection<MethodHandle>> callSiteCache = new LRUCache(8);
    private Expression<Object> targetArg;
    private Expression<Object> args;
    private Type type;
    private boolean isDynamic;
    private boolean suppressErrors = false;
    private Descriptor staticDescriptor;
    private Expression<String> dynamicDescriptor;
    private final ExprJavaCall<?> source;
    private final Class<? extends T>[] types;
    private final Class<T> superType;

    public ExprJavaCall() {
        this(null, Object.class);
    }

    @SafeVarargs
    private ExprJavaCall(ExprJavaCall<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.targetArg = source.targetArg;
            this.args = source.args;
            this.type = source.type;
            this.suppressErrors = source.suppressErrors;
            this.staticDescriptor = source.staticDescriptor;
            this.dynamicDescriptor = source.dynamicDescriptor;
        }
        this.types = types;
        this.superType = Utils.getSuperType((Class[])types);
    }

    private Collection<MethodHandle> getCallSite(Descriptor e) {
        return this.callSiteCache.computeIfAbsent(e, this::createCallSite);
    }

    private Collection<MethodHandle> createCallSite(Descriptor e) {
        Class<?> javaClass = e.getJavaClass();
        switch (this.type) {
            case FIELD: {
                return Util.fields(javaClass).filter(f -> f.getName().equals(e.getIdentifier())).peek(f -> f.setAccessible(true)).flatMap(Util.propagateErrors(f -> Stream.of(LOOKUP.unreflectGetter((Field)f), LOOKUP.unreflectSetter((Field)f)))).limit(2L).collect(Collectors.toList());
            }
            case METHOD: {
                return Util.methods(javaClass).filter(m -> m.getName().equals(e.getIdentifier())).peek(m -> m.setAccessible(true)).map(Util.propagateErrors(LOOKUP::unreflect)).collect(Collectors.toList());
            }
            case CONSTRUCTOR: {
                return Util.constructor(javaClass).peek(c -> c.setAccessible(true)).map(Util.propagateErrors(LOOKUP::unreflectConstructor)).collect(Collectors.toList());
            }
        }
        throw new IllegalStateException();
    }

    private static MethodHandle asSpreader(MethodHandle mh) {
        int paramCount = mh.type().parameterCount();
        if (mh.isVarargsCollector()) {
            if (paramCount == 1) {
                return mh;
            }
            return mh.asSpreader(Object[].class, paramCount - 1);
        }
        return mh.asSpreader(Object[].class, paramCount);
    }

    private T[] invoke(Object target, Object[] arguments, Descriptor baseDescriptor) {
        Object returnedValue = null;
        Class<?> targetClass = Util.toClass(target);
        Descriptor descriptor = ExprJavaCall.specifyDescriptor(baseDescriptor, targetClass);
        Object[] argTypes = null;
        if (descriptor.getJavaClass().isAssignableFrom(targetClass)) {
            Object[] arr;
            if (target instanceof JavaType) {
                arr = new Object[arguments.length];
                System.arraycopy(arguments, 0, arr, 0, arguments.length);
            } else {
                arr = new Object[arguments.length + 1];
                arr[0] = target;
                System.arraycopy(arguments, 0, arr, 1, arguments.length);
            }
            argTypes = (Class[])Arrays.stream(arr).map(Object::getClass).toArray(Class[]::new);
            Optional<MethodHandle> method = this.selectMethod(descriptor, (Class<?>[])argTypes);
            if (method.isPresent()) {
                MethodHandle mh = method.get();
                ExprJavaCall.convertTypes(mh.type(), arr);
                try {
                    returnedValue = mh.invokeWithArguments(arr);
                }
                catch (Throwable throwable) {
                    if (!this.suppressErrors) {
                        Skript.warning((String)String.format("%s (%s) -> %s called with %s (%s) threw a %s: %s%nRun Skript with the verbosity 'very high' for the stack trace.", target, targetClass, this.toString(descriptor), Arrays.toString(arguments), Arrays.toString(argTypes), throwable.getClass(), throwable.getMessage()));
                        if (Skript.logVeryHigh()) {
                            StringWriter errors = new StringWriter();
                            throwable.printStackTrace(new PrintWriter(errors));
                            Skript.warning((String)errors.toString());
                        }
                    }
                }
            } else if (!this.suppressErrors) {
                Skript.warning((String)String.format("%s (%s) -> %s could not be resolved with the arguments %s (%s)", target, targetClass, this.toString(descriptor), Arrays.toString(arguments), Arrays.toString(argTypes)));
            }
        } else if (!this.suppressErrors) {
            Skript.warning((String)String.format("%s (%s) is not a %s", target, targetClass, descriptor.getJavaClass()));
        }
        if (returnedValue == null) {
            return Util.newArray(this.superType, 0);
        }
        if ((returnedValue = Converters.convert(returnedValue, (Class[])this.types)) == null) {
            if (!this.suppressErrors) {
                Skript.warning((String)String.format("%s (%s) -> %s called with %s (%s) could not be converted to %s", target, targetClass, this.toString(descriptor), Arrays.toString(arguments), Arrays.toString(argTypes), Arrays.toString(this.types)));
            }
            return Util.newArray(this.superType, 0);
        }
        T[] returnArray = Util.newArray(this.superType, 1);
        returnArray[0] = returnedValue;
        return returnArray;
    }

    private Descriptor getDescriptor(Event e) {
        if (this.isDynamic) {
            String desc = (String)this.dynamicDescriptor.getSingle(e);
            if (desc == null) {
                return null;
            }
            try {
                return Descriptor.parse(desc);
            }
            catch (ClassNotFoundException ex) {
                if (!this.suppressErrors) {
                    Skript.exception((Throwable)ex, (String[])new String[0]);
                }
                return Descriptor.create(null);
            }
        }
        return this.staticDescriptor;
    }

    private static Descriptor specifyDescriptor(Descriptor descriptor, Class<?> cls) {
        if (descriptor.getJavaClass() != null) {
            return descriptor;
        }
        return Descriptor.create(cls, descriptor.getIdentifier());
    }

    private Optional<MethodHandle> selectMethod(Descriptor descriptor, Class<?>[] argTypes) {
        return this.getCallSite(descriptor).stream().filter(mh -> ExprJavaCall.matchesArgs(argTypes, mh)).findFirst();
    }

    private static boolean matchesArgs(Class<?>[] args, MethodHandle mh) {
        MethodType mt = mh.type();
        if (mt.parameterCount() != args.length && !mh.isVarargsCollector()) {
            return false;
        }
        Class<?>[] params = mt.parameterArray();
        for (int i = 0; !(i >= params.length || i == params.length - 1 && mh.isVarargsCollector()); ++i) {
            Class<?> param = params[i];
            Class<?> arg = args[i];
            if (param.isAssignableFrom(arg) || Number.class.isAssignableFrom(arg) && NUMERIC_CLASSES.contains(param) || param.isPrimitive() && arg == WRAPPER_CLASSES.get(param)) continue;
            return false;
        }
        return true;
    }

    private static void convertTypes(MethodType mt, Object[] args) {
        if (!mt.hasPrimitives()) {
            return;
        }
        Class<?>[] params = mt.parameterArray();
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            if (!param.isPrimitive()) continue;
            if (param == Byte.TYPE) {
                args[i] = ((Number)args[i]).byteValue();
                continue;
            }
            if (param == Double.TYPE) {
                args[i] = ((Number)args[i]).doubleValue();
                continue;
            }
            if (param == Float.TYPE) {
                args[i] = Float.valueOf(((Number)args[i]).floatValue());
                continue;
            }
            if (param == Integer.TYPE) {
                args[i] = ((Number)args[i]).intValue();
                continue;
            }
            if (param == Long.TYPE) {
                args[i] = ((Number)args[i]).longValue();
                continue;
            }
            if (param != Short.TYPE) continue;
            args[i] = ((Number)args[i]).shortValue();
        }
    }

    void setSuppressErrors(boolean suppressErrors) {
        this.suppressErrors = suppressErrors;
        if (this.targetArg instanceof ExprJavaCall) {
            ((ExprJavaCall)this.targetArg).setSuppressErrors(suppressErrors);
        }
    }

    public T getSingle(Event e) {
        T[] all = this.getArray(e);
        if (all.length == 0) {
            return null;
        }
        return all[0];
    }

    public T[] getArray(Event e) {
        return this.getAll(e);
    }

    public T[] getAll(Event e) {
        Object[] arguments;
        Object target = this.targetArg.getSingle(e);
        if (target == null) {
            return null;
        }
        if (this.args != null) {
            try {
                arguments = this.args.getArray(e);
            }
            catch (SkriptAPIException ex) {
                Skript.error((String)("The arguments passed to " + this.getDescriptor(e) + " could not be parsed. Try " + "setting a list variable to the arguments and pass that variable to the reflection " + "call instead!"));
                return null;
            }
        } else {
            arguments = NO_ARGS;
        }
        return this.invoke(target, arguments, this.getDescriptor(e));
    }

    public boolean isSingle() {
        return true;
    }

    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return SimpleExpression.check((Object[])this.getAll(e), c, (boolean)negated, (boolean)this.getAnd());
    }

    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check((Object[])this.getAll(e), c, (boolean)false, (boolean)this.getAnd());
    }

    public <R> Expression<? extends R> getConvertedExpression(Class<R>[] to) {
        return new ExprJavaCall<R>(this, to);
    }

    public Class<T> getReturnType() {
        return this.superType;
    }

    public boolean getAnd() {
        return true;
    }

    public boolean setTime(int time) {
        return false;
    }

    public int getTime() {
        return 0;
    }

    public boolean isDefault() {
        return false;
    }

    public Iterator<? extends T> iterator(Event e) {
        return new ArrayIterator((Object[])this.getAll(e));
    }

    public boolean isLoopOf(String s) {
        return false;
    }

    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    public Expression<? extends T> simplify() {
        return this;
    }

    public String toString(Event e, boolean debug) {
        return this.toString(this.getDescriptor(e));
    }

    private String toString(Descriptor descriptor) {
        return (Object)((Object)this.type) + " " + descriptor;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.type == Type.FIELD && (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE)) {
            return new Class[]{Object.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Object target = this.targetArg.getSingle(e);
        if (target == null) {
            return;
        }
        Object[] args = new Object[1];
        switch (mode) {
            case SET: {
                args[0] = delta[0];
                break;
            }
            case DELETE: {
                args[0] = null;
            }
        }
        this.invoke(target, args, this.getDescriptor(e));
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.targetArg = exprs[0];
        this.args = exprs[matchedPattern == 0 ? 2 : 1];
        if (this.targetArg instanceof UnparsedLiteral || this.args instanceof UnparsedLiteral) {
            return false;
        }
        switch (matchedPattern) {
            case 0: {
                this.isDynamic = true;
                this.type = parseResult.mark == 0 ? Type.FIELD : Type.METHOD;
                this.dynamicDescriptor = exprs[1];
                break;
            }
            case 1: {
                this.isDynamic = false;
                this.type = parseResult.mark == 0 ? Type.FIELD : Type.METHOD;
                String desc = ((MatchResult)parseResult.regexes.get(0)).group();
                try {
                    this.staticDescriptor = Descriptor.parse(desc);
                    if (this.staticDescriptor == null) {
                        Skript.error((String)(desc + " is not a valid descriptor."));
                        return false;
                    }
                    if (this.staticDescriptor.getJavaClass() != null && this.getCallSite(this.staticDescriptor).size() == 0) {
                        Skript.error((String)(desc + " refers to a non-existent method/field."));
                        return false;
                    }
                    break;
                }
                catch (ClassNotFoundException e) {
                    Skript.error((String)(desc + " refers to a non-existent class."));
                    return false;
                }
            }
            case 2: {
                this.type = Type.CONSTRUCTOR;
                this.staticDescriptor = CONSTRUCTOR_DESCRIPTOR;
            }
        }
        return true;
    }

    static {
        WRAPPER_CLASSES.put(Boolean.TYPE, Boolean.class);
        WRAPPER_CLASSES.put(Byte.TYPE, Byte.class);
        WRAPPER_CLASSES.put(Character.TYPE, Character.class);
        WRAPPER_CLASSES.put(Double.TYPE, Double.class);
        WRAPPER_CLASSES.put(Float.TYPE, Float.class);
        WRAPPER_CLASSES.put(Integer.TYPE, Integer.class);
        WRAPPER_CLASSES.put(Long.TYPE, Long.class);
        WRAPPER_CLASSES.put(Short.TYPE, Short.class);
        NUMERIC_CLASSES.add(Byte.TYPE);
        NUMERIC_CLASSES.add(Double.TYPE);
        NUMERIC_CLASSES.add(Float.TYPE);
        NUMERIC_CLASSES.add(Integer.TYPE);
        NUMERIC_CLASSES.add(Long.TYPE);
        NUMERIC_CLASSES.add(Short.TYPE);
        Skript.registerExpression(ExprJavaCall.class, Object.class, (ExpressionType)ExpressionType.PATTERN_MATCHES_EVERYTHING, (String[])new String[]{"%object%..%string%(0\u00a6!|1\u00a6\\([%-objects%]\\))", "%object%.<[\\w$.\\[\\]]+>(0\u00a6!|1\u00a6\\([%-objects%]\\))", "new %javatype%\\([%-objects%]\\)"});
    }

    private static enum Type {
        FIELD,
        METHOD,
        CONSTRUCTOR;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

