/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import com.btk5h.skriptmirror.SkriptMirror;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class EvtByReflection
extends SkriptEvent {
    private static EventExecutor executor;
    private static PriorityListener[] listeners;
    private static Set<Class<? extends Event>> events;
    private Class<? extends Event>[] classes;
    private EventPriority priority;

    private static void registerEvent(Class<? extends Event> event, EventPriority priority) {
        PriorityListener listener = listeners[priority.ordinal()];
        Set<Class<? extends Event>> events = listener.getEvents();
        if (!events.contains(event)) {
            events.add(event);
            Bukkit.getPluginManager().registerEvent(event, (Listener)listener, priority, executor, (Plugin)SkriptMirror.getInstance());
        }
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        String[] events = (String[])args[0].getArray();
        this.classes = (Class[])Array.newInstance(Class.class, events.length);
        for (int i = 0; i < events.length; ++i) {
            String event = events[i];
            try {
                Class<?> eventClass = Class.forName(event);
                if (!Event.class.isAssignableFrom(eventClass)) {
                    Skript.error((String)(event + " is not an event."));
                    return false;
                }
                this.classes[i] = eventClass;
                continue;
            }
            catch (ClassNotFoundException e) {
                Skript.error((String)(event + " refers to a non-existent class."));
                return false;
            }
        }
        if (args[1] == null) {
            this.priority = (EventPriority)SkriptConfig.defaultEventPriority.value();
        } else {
            int priorityIndex = ((Number)args[1].getSingle()).intValue();
            priorityIndex = Math.max(0, Math.min(priorityIndex, listeners.length - 1));
            this.priority = listeners[priorityIndex].getPriority();
        }
        for (Class<? extends Event> cls : this.classes) {
            EvtByReflection.registerEvent(cls, this.priority);
        }
        return true;
    }

    public boolean check(Event e) {
        Class<?> eventClass = ((BukkitEvent)e).getEvent().getClass();
        if (this.priority == ((BukkitEvent)e).getPriority()) {
            for (Class<? extends Event> cls : this.classes) {
                if (cls != eventClass) continue;
                return true;
            }
        }
        return false;
    }

    public String toString(Event e, boolean debug) {
        return Arrays.toString(this.classes) + " priority " + this.priority;
    }

    static {
        Skript.registerEvent((String)"Bukkit Event", EvtByReflection.class, BukkitEvent.class, (String[])new String[]{"%strings% [(at|on|with) priority %-number%]"});
        executor = new EventExecutor(){

            public void execute(Listener listener, Event event) throws EventException {
                Bukkit.getPluginManager().callEvent((Event)new BukkitEvent(event, ((PriorityListener)listener).getPriority()));
            }
        };
        listeners = new PriorityListener[]{new PriorityListener(0), new PriorityListener(1), new PriorityListener(2), new PriorityListener(3), new PriorityListener(4), new PriorityListener(5)};
        events = new HashSet<Class<? extends Event>>();
    }

    static class BukkitEvent
    extends Event {
        private static final HandlerList handlers = new HandlerList();
        private final Event event;
        private final EventPriority priority;

        public BukkitEvent(Event event, EventPriority priority) {
            this.event = event;
            this.priority = priority;
        }

        public Event getEvent() {
            return this.event;
        }

        public EventPriority getPriority() {
            return this.priority;
        }

        public static HandlerList getHandlerList() {
            return handlers;
        }

        public HandlerList getHandlers() {
            return handlers;
        }
    }

    private static class PriorityListener
    implements Listener {
        private EventPriority priority;
        private Set<Class<? extends Event>> events = new HashSet<Class<? extends Event>>();

        public PriorityListener(int priority) {
            this.priority = EventPriority.values()[priority];
        }

        public EventPriority getPriority() {
            return this.priority;
        }

        public Set<Class<? extends Event>> getEvents() {
            return this.events;
        }
    }
}

