/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.btk5h.skriptmirror.Descriptor;
import com.btk5h.skriptmirror.JavaType;
import com.btk5h.skriptmirror.LRUCache;
import com.btk5h.skriptmirror.Util;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.event.Event;

public class ExprJavaCall
extends SimpleExpression<Object> {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final Object[] NO_ARGS = new Object[0];
    private static final Descriptor CONSTRUCTOR_DESCRIPTOR = Descriptor.create("<init>");
    private static final Map<Class<?>, Class<?>> WRAPPER_CLASSES = new HashMap();
    private static final Set<Class<?>> NUMERIC_CLASSES = new HashSet();
    private LRUCache<Descriptor, Collection<MethodHandle>> callSiteCache = new LRUCache(8);
    private Expression<Object> target;
    private Expression<Object> args;
    private Type type;
    private boolean isDynamic;
    private Descriptor staticDescriptor;
    private Expression<String> dynamicDescriptor;

    private Collection<MethodHandle> getCallSite(Descriptor e) {
        return this.callSiteCache.computeIfAbsent(e, this::createCallSite);
    }

    private Collection<MethodHandle> createCallSite(Descriptor e) {
        Class<?> javaClass = e.getJavaClass();
        switch (this.type) {
            case FIELD: {
                return Util.fields(javaClass).filter(f -> f.getName().equals(e.getIdentifier())).peek(f -> f.setAccessible(true)).flatMap(Util.propagateErrors(f -> Stream.of(LOOKUP.unreflectGetter((Field)f), LOOKUP.unreflectSetter((Field)f)))).limit(2L).collect(Collectors.toList());
            }
            case METHOD: {
                return Util.methods(javaClass).filter(m -> m.getName().equals(e.getIdentifier())).peek(m -> m.setAccessible(true)).map(Util.propagateErrors(LOOKUP::unreflect)).collect(Collectors.toList());
            }
            case CONSTRUCTOR: {
                return Util.constructor(javaClass).peek(c -> c.setAccessible(true)).map(Util.propagateErrors(LOOKUP::unreflectConstructor)).collect(Collectors.toList());
            }
        }
        throw new IllegalStateException();
    }

    private static MethodHandle asSpreader(MethodHandle mh) {
        int paramCount = mh.type().parameterCount();
        if (mh.isVarargsCollector()) {
            if (paramCount == 1) {
                return mh;
            }
            return mh.asSpreader(Object[].class, paramCount - 1);
        }
        return mh.asSpreader(Object[].class, paramCount);
    }

    protected Object[] get(Event e) {
        Object[] arguments;
        Object[] targets = this.target.getArray(e);
        if (this.args != null) {
            try {
                arguments = this.args.getArray(e);
            }
            catch (SkriptAPIException ex) {
                Skript.error((String)("The arguments passed to " + this.getDescriptor(e) + " could not be parsed. Try " + "setting a list variable to the arguments and pass that variable to the reflection " + "call instead!"));
                return null;
            }
        } else {
            arguments = NO_ARGS;
        }
        Descriptor baseDescriptor = this.getDescriptor(e);
        return this.invoke(targets, arguments, baseDescriptor);
    }

    private Object[] invoke(Object[] targets, Object[] arguments, Descriptor baseDescriptor) {
        ArrayList<Object> returnedValues = new ArrayList<Object>();
        for (Object obj : targets) {
            Object[] arr;
            Class<?> targetClass = Util.toClass(obj);
            Descriptor descriptor = ExprJavaCall.specifyDescriptor(baseDescriptor, targetClass);
            if (!descriptor.getJavaClass().isAssignableFrom(targetClass)) continue;
            if (obj instanceof JavaType) {
                arr = new Object[arguments.length];
                System.arraycopy(arguments, 0, arr, 0, arguments.length);
            } else {
                arr = new Object[arguments.length + 1];
                arr[0] = obj;
                System.arraycopy(arguments, 0, arr, 1, arguments.length);
            }
            Class[] argTypes = (Class[])Arrays.stream(arr).map(Object::getClass).toArray(Class[]::new);
            Optional<MethodHandle> method = this.selectMethod(descriptor, argTypes);
            if (!method.isPresent()) continue;
            MethodHandle mh = method.get();
            ExprJavaCall.convertTypes(mh.type(), arr);
            try {
                Object value = mh.invokeWithArguments(arr);
                if (mh.type().returnType() == Void.TYPE) continue;
                returnedValues.add(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return returnedValues.toArray();
    }

    private Descriptor getDescriptor(Event e) {
        if (this.isDynamic) {
            String desc = (String)this.dynamicDescriptor.getSingle(e);
            if (desc == null) {
                return null;
            }
            try {
                return Descriptor.parse(desc);
            }
            catch (ClassNotFoundException ignored) {
                return Descriptor.create(null);
            }
        }
        return this.staticDescriptor;
    }

    private static Descriptor specifyDescriptor(Descriptor descriptor, Class<?> cls) {
        if (descriptor.getJavaClass() != null) {
            return descriptor;
        }
        return Descriptor.create(cls, descriptor.getIdentifier());
    }

    private Optional<MethodHandle> selectMethod(Descriptor descriptor, Class<?>[] argTypes) {
        return this.getCallSite(descriptor).stream().filter(mh -> ExprJavaCall.matchesArgs(argTypes, mh)).findFirst();
    }

    private static boolean matchesArgs(Class<?>[] args, MethodHandle mh) {
        MethodType mt = mh.type();
        if (mt.parameterCount() != args.length && !mh.isVarargsCollector()) {
            return false;
        }
        Class<?>[] params = mt.parameterArray();
        for (int i = 0; !(i >= params.length || i == params.length - 1 && mh.isVarargsCollector()); ++i) {
            Class<?> param = params[i];
            Class<?> arg = args[i];
            if (param.isAssignableFrom(arg) || Number.class.isAssignableFrom(arg) && NUMERIC_CLASSES.contains(param) || param.isPrimitive() && arg == WRAPPER_CLASSES.get(param)) continue;
            return false;
        }
        return true;
    }

    private static void convertTypes(MethodType mt, Object[] args) {
        if (!mt.hasPrimitives()) {
            return;
        }
        Class<?>[] params = mt.parameterArray();
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            if (!param.isPrimitive()) continue;
            if (param == Byte.TYPE) {
                args[i] = ((Number)args[i]).byteValue();
                continue;
            }
            if (param == Double.TYPE) {
                args[i] = ((Number)args[i]).doubleValue();
                continue;
            }
            if (param == Float.TYPE) {
                args[i] = Float.valueOf(((Number)args[i]).floatValue());
                continue;
            }
            if (param == Integer.TYPE) {
                args[i] = ((Number)args[i]).intValue();
                continue;
            }
            if (param == Long.TYPE) {
                args[i] = ((Number)args[i]).longValue();
                continue;
            }
            if (param != Short.TYPE) continue;
            args[i] = ((Number)args[i]).shortValue();
        }
    }

    public boolean isSingle() {
        return this.target.isSingle();
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    public String toString(Event e, boolean debug) {
        return (Object)((Object)this.type) + " " + this.getDescriptor(e);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.type == Type.FIELD && (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE)) {
            return new Class[]{Object.class};
        }
        return super.acceptChange(mode);
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Object[] args = new Object[1];
        switch (mode) {
            case SET: {
                args[0] = delta[0];
                break;
            }
            case DELETE: {
                args[0] = null;
            }
        }
        Descriptor baseDescriptor = this.getDescriptor(e);
        this.invoke(this.target.getArray(e), args, baseDescriptor);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.target = exprs[0];
        this.args = exprs[matchedPattern == 0 ? 2 : 1];
        if (this.target instanceof UnparsedLiteral || this.args instanceof UnparsedLiteral) {
            return false;
        }
        switch (matchedPattern) {
            case 0: {
                this.isDynamic = true;
                this.type = parseResult.mark == 0 ? Type.FIELD : Type.METHOD;
                this.dynamicDescriptor = exprs[1];
                break;
            }
            case 1: {
                this.isDynamic = false;
                this.type = parseResult.mark == 0 ? Type.FIELD : Type.METHOD;
                String desc = ((MatchResult)parseResult.regexes.get(0)).group();
                try {
                    this.staticDescriptor = Descriptor.parse(desc);
                    if (this.staticDescriptor == null) {
                        Skript.error((String)(desc + " is not a valid descriptor."));
                        return false;
                    }
                    if (this.staticDescriptor.getJavaClass() != null && this.getCallSite(this.staticDescriptor).size() == 0) {
                        Skript.error((String)(desc + " refers to a non-existent method/field."));
                        return false;
                    }
                    break;
                }
                catch (ClassNotFoundException e) {
                    Skript.error((String)(desc + " refers to a non-existent class."));
                    return false;
                }
            }
            case 2: {
                this.type = Type.CONSTRUCTOR;
                this.staticDescriptor = CONSTRUCTOR_DESCRIPTOR;
            }
        }
        return true;
    }

    static {
        WRAPPER_CLASSES.put(Boolean.TYPE, Boolean.class);
        WRAPPER_CLASSES.put(Byte.TYPE, Byte.class);
        WRAPPER_CLASSES.put(Character.TYPE, Character.class);
        WRAPPER_CLASSES.put(Double.TYPE, Double.class);
        WRAPPER_CLASSES.put(Float.TYPE, Float.class);
        WRAPPER_CLASSES.put(Integer.TYPE, Integer.class);
        WRAPPER_CLASSES.put(Long.TYPE, Long.class);
        WRAPPER_CLASSES.put(Short.TYPE, Short.class);
        NUMERIC_CLASSES.add(Byte.TYPE);
        NUMERIC_CLASSES.add(Double.TYPE);
        NUMERIC_CLASSES.add(Float.TYPE);
        NUMERIC_CLASSES.add(Integer.TYPE);
        NUMERIC_CLASSES.add(Long.TYPE);
        NUMERIC_CLASSES.add(Short.TYPE);
        Skript.registerExpression(ExprJavaCall.class, Object.class, (ExpressionType)ExpressionType.PATTERN_MATCHES_EVERYTHING, (String[])new String[]{"%objects%..%string%(0\u00a6!|1\u00a6\\([%-objects%]\\))", "%objects%.<[\\w$.\\[\\]]+>(0\u00a6!|1\u00a6\\([%-objects%]\\))", "new %javatype%\\([%-objects%]\\)"});
    }

    private static enum Type {
        FIELD,
        METHOD,
        CONSTRUCTOR;

    }
}

