/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.util;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import com.btk5h.skriptmirror.util.SkriptReflection;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SkriptUtil {
    public static <T> Expression<T> defendExpression(Expression<?> expr) {
        if (expr instanceof UnparsedLiteral) {
            Literal parsed = ((UnparsedLiteral)expr).getConvertedExpression(new Class[]{Object.class});
            return parsed == null ? expr : parsed;
        }
        if (expr instanceof ExpressionList) {
            Expression[] exprs = ((ExpressionList)expr).getExpressions();
            for (int i = 0; i < exprs.length; ++i) {
                exprs[i] = SkriptUtil.defendExpression(exprs[i]);
            }
        }
        return expr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasUnparsedLiteral(Expression<?> expr) {
        if (expr instanceof UnparsedLiteral) return true;
        if (!(expr instanceof ExpressionList)) return false;
        if (!Arrays.stream(((ExpressionList)expr).getExpressions()).anyMatch(UnparsedLiteral.class::isInstance)) return false;
        return true;
    }

    public static boolean canInitSafely(Expression<?> ... expressions) {
        return Arrays.stream(expressions).filter(Objects::nonNull).noneMatch(SkriptUtil::hasUnparsedLiteral);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<List<TriggerItem>> getItemsFromNode(SectionNode node, String key) {
        Node subNode = node.get(key);
        if (!(subNode instanceof SectionNode)) {
            return Optional.empty();
        }
        RetainingLogHandler log = SkriptLogger.startRetainingLog();
        try {
            Optional<List<TriggerItem>> optional = Optional.of(ScriptLoader.loadItems((SectionNode)((SectionNode)subNode)));
            return optional;
        }
        finally {
            SkriptReflection.printLog(log);
            ScriptLoader.deleteCurrentEvent();
        }
    }

    public static void clearSectionNode(SectionNode node) {
        ArrayList subNodes = new ArrayList();
        node.forEach(subNodes::add);
        subNodes.forEach(Node::remove);
    }

    public static File getCurrentScript() {
        Config currentScript = ScriptLoader.currentScript;
        return currentScript == null ? null : currentScript.getFile();
    }
}

