/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom.effect;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxSection;
import com.btk5h.skriptmirror.skript.custom.SyntaxParseEvent;
import com.btk5h.skriptmirror.skript.custom.effect.CustomEffect;
import com.btk5h.skriptmirror.skript.custom.effect.EffectSyntaxInfo;
import com.btk5h.skriptmirror.skript.custom.effect.EffectTriggerEvent;
import com.btk5h.skriptmirror.util.SkriptUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.MatchResult;

public class CustomEffectSection
extends CustomSyntaxSection<EffectSyntaxInfo> {
    private static CustomSyntaxSection.DataTracker<EffectSyntaxInfo> dataTracker;
    static final Map<EffectSyntaxInfo, Trigger> effectHandlers;
    static final Map<EffectSyntaxInfo, Trigger> parserHandlers;

    @Override
    public CustomSyntaxSection.DataTracker<EffectSyntaxInfo> getDataTracker() {
        return dataTracker;
    }

    @Override
    protected boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult, SectionNode node) {
        SectionNode patterns = (SectionNode)node.get("patterns");
        File script = (parseResult.mark & 1) == 1 ? SkriptUtil.getCurrentScript() : null;
        switch (matchedPattern) {
            case 0: {
                this.register(EffectSyntaxInfo.create(script, ((MatchResult)parseResult.regexes.get(0)).group(), 1));
                break;
            }
            case 1: {
                if (patterns == null) {
                    Skript.error((String)"Custom effects without inline patterns must have a patterns section.");
                    return false;
                }
                int i = 1;
                for (Node subNode : patterns) {
                    this.register(EffectSyntaxInfo.create(script, subNode.getKey(), i++));
                }
                break;
            }
        }
        if (matchedPattern != 1 && patterns != null) {
            Skript.error((String)"Custom effects with inline patterns may not have a patterns section.");
            return false;
        }
        ScriptLoader.setCurrentEvent((String)"custom effect trigger", (Class[])new Class[]{EffectTriggerEvent.class});
        SkriptUtil.getItemsFromNode(node, "trigger").ifPresent(items -> this.whichInfo.forEach(which -> effectHandlers.put((EffectSyntaxInfo)which, new Trigger(ScriptLoader.currentScript.getFile(), "effect " + which, (SkriptEvent)this, items))));
        SyntaxParseEvent.register(this, node, this.whichInfo, parserHandlers);
        return true;
    }

    public static EffectSyntaxInfo lookup(File script, int matchedPattern) {
        return dataTracker.lookup(script, matchedPattern);
    }

    static {
        CustomSyntaxSection.register("Define Effect", CustomEffectSection.class, "[(1\u00a6local)] effect <.+>", "[(1\u00a6local)] effect");
        dataTracker = new CustomSyntaxSection.DataTracker();
        effectHandlers = new HashMap<EffectSyntaxInfo, Trigger>();
        parserHandlers = new HashMap<EffectSyntaxInfo, Trigger>();
        dataTracker.setSyntaxType("effect");
        dataTracker.getValidator().addSection("trigger", false).addSection("patterns", true).addSection("parse", true);
        Skript.registerEffect(CustomEffect.class, (String[])new String[0]);
        Optional<SyntaxElementInfo> info = Skript.getEffects().stream().filter(i -> i.c == CustomEffect.class).findFirst();
        info.ifPresent(dataTracker::setInfo);
        dataTracker.addManaged(effectHandlers);
        dataTracker.addManaged(parserHandlers);
    }
}

