/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom.expression;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.ArrayIterator;
import com.btk5h.skriptmirror.skript.custom.SyntaxParseEvent;
import com.btk5h.skriptmirror.skript.custom.expression.CustomExpressionSection;
import com.btk5h.skriptmirror.skript.custom.expression.ExpressionChangeEvent;
import com.btk5h.skriptmirror.skript.custom.expression.ExpressionGetEvent;
import com.btk5h.skriptmirror.skript.custom.expression.SyntaxInfo;
import com.btk5h.skriptmirror.util.JavaUtil;
import com.btk5h.skriptmirror.util.SkriptReflection;
import com.btk5h.skriptmirror.util.SkriptUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.bukkit.event.Event;

public class CustomExpression<T>
implements Expression<T> {
    private SyntaxInfo which;
    private Expression<?>[] exprs;
    private int matchedPattern;
    private SkriptParser.ParseResult parseResult;
    private Event parseEvent;
    private final CustomExpression<?> source;
    private final Class<? extends T>[] types;
    private final Class<T> superType;

    public CustomExpression() {
        this(null, Object.class);
    }

    @SafeVarargs
    private CustomExpression(CustomExpression<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.which = source.which;
            this.exprs = source.exprs;
            this.matchedPattern = source.matchedPattern;
            this.parseResult = source.parseResult;
            this.parseEvent = source.parseEvent;
        }
        this.types = types;
        this.superType = Utils.getSuperType((Class[])types);
    }

    public T getSingle(Event e) {
        T[] all = this.getAll(e);
        return all.length == 0 ? null : (T)all[0];
    }

    public T[] getArray(Event e) {
        return this.getAll(e);
    }

    public T[] getAll(Event e) {
        Trigger getter = CustomExpressionSection.expressionHandlers.get(this.which);
        if (getter == null) {
            Skript.error((String)String.format("The custom expression '%s' no longer has a get handler.", this.which.getPattern()));
            return JavaUtil.newArray(this.superType, 0);
        }
        if (this.which.isProperty()) {
            return this.getByProperty(e, getter);
        }
        return this.getByStandard(e, getter);
    }

    private T[] getByStandard(Event e, Trigger getter) {
        ExpressionGetEvent expressionEvent = new ExpressionGetEvent(e, this.exprs, this.matchedPattern, this.parseResult);
        SkriptReflection.copyVariablesMap(this.parseEvent, expressionEvent);
        getter.execute((Event)expressionEvent);
        if (expressionEvent.getOutput() == null) {
            Skript.error((String)String.format("The get handler for '%s' did not return.", this.which.getPattern()));
            return JavaUtil.newArray(this.superType, 0);
        }
        return Converters.convertArray((Object[])expressionEvent.getOutput(), (Class[])this.types, this.superType);
    }

    private T[] getByProperty(Event e, Trigger getter) {
        ArrayList<Object> output = new ArrayList<Object>();
        for (Object o : this.exprs[0].getArray(e)) {
            Expression<?>[] localExprs = Arrays.copyOf(this.exprs, this.exprs.length);
            localExprs[0] = new SimpleLiteral(o, false);
            ExpressionGetEvent expressionEvent = new ExpressionGetEvent(e, localExprs, this.matchedPattern, this.parseResult);
            SkriptReflection.copyVariablesMap(this.parseEvent, expressionEvent);
            getter.execute((Event)expressionEvent);
            Object[] exprOutput = expressionEvent.getOutput();
            if (exprOutput == null) {
                Skript.error((String)String.format("The get handler for '%s' did not return.", this.which.getPattern()));
                return JavaUtil.newArray(this.superType, 0);
            }
            if (exprOutput.length > 1) {
                Skript.error((String)String.format("The get handler for '%s' returned more than one value.", this.which.getPattern()));
                return JavaUtil.newArray(this.superType, 0);
            }
            if (exprOutput.length != 1) continue;
            output.add(Converters.convert((Object)exprOutput[0], this.superType));
        }
        return output.toArray(JavaUtil.newArray(this.superType, 0));
    }

    public boolean isSingle() {
        return !this.which.isAlwaysPlural() && Arrays.stream(this.which.getInheritedSingles()).mapToObj(i -> this.exprs[i]).filter(Objects::nonNull).allMatch(Expression::isSingle);
    }

    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return SimpleExpression.check((Object[])this.getAll(e), c, (boolean)negated, (boolean)this.getAnd());
    }

    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check((Object[])this.getAll(e), c, (boolean)false, (boolean)this.getAnd());
    }

    public <R> Expression<? extends R> getConvertedExpression(Class<R>[] to) {
        if (CustomExpressionSection.returnTypes.containsKey(this.which) && !Converters.converterExists(CustomExpressionSection.returnTypes.get(this.which), (Class[])to)) {
            return null;
        }
        return new CustomExpression<R>(this, to);
    }

    public Class<T> getReturnType() {
        return this.superType;
    }

    public boolean getAnd() {
        return true;
    }

    public boolean setTime(int time) {
        return false;
    }

    public int getTime() {
        return 0;
    }

    public boolean isDefault() {
        return false;
    }

    public Iterator<? extends T> iterator(Event e) {
        return new ArrayIterator((Object[])this.getAll(e));
    }

    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase(CustomExpressionSection.loopOfs.get(this.which));
    }

    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    public Expression<? extends T> simplify() {
        return this;
    }

    public String toString(Event e, boolean debug) {
        return this.which.getPattern();
    }

    public String toString() {
        return this.toString(null, false);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        if (CustomExpressionSection.changerHandlers.containsKey(this.which) && CustomExpressionSection.changerHandlers.get(this.which).containsKey(mode)) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Object[].class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Trigger changer = (Trigger)CustomExpressionSection.changerHandlers.getOrDefault(this.which, Collections.emptyMap()).get(mode);
        if (changer == null) {
            Skript.error((String)String.format("The custom expression '%s' no longer has a %s handler.", this.which.getPattern(), mode.name()));
        } else {
            ExpressionChangeEvent changeEvent = new ExpressionChangeEvent(e, this.exprs, this.matchedPattern, this.parseResult, delta);
            SkriptReflection.copyVariablesMap(this.parseEvent, changeEvent);
            changer.execute((Event)changeEvent);
        }
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.which = CustomExpressionSection.lookup(SkriptUtil.getCurrentScript(), matchedPattern);
        if (this.which == null) {
            return false;
        }
        if (this.which.shouldAdaptArgument()) {
            Expression<?> lastExpression = exprs[exprs.length - 1];
            System.arraycopy(exprs, 0, exprs, 1, exprs.length - 1);
            exprs[0] = lastExpression;
        }
        this.exprs = (Expression[])Arrays.stream(exprs).map(SkriptUtil::defendExpression).toArray(Expression[]::new);
        this.matchedPattern = matchedPattern;
        this.parseResult = parseResult;
        if (!SkriptUtil.canInitSafely(this.exprs)) {
            return false;
        }
        Trigger parseHandler = CustomExpressionSection.parserHandlers.get(this.which);
        if (parseHandler != null) {
            SyntaxParseEvent event = new SyntaxParseEvent(this.exprs, matchedPattern, parseResult, ScriptLoader.getCurrentEvents());
            parseHandler.execute((Event)event);
            if (SkriptReflection.hasLocalVariables(event)) {
                this.parseEvent = event;
            }
            return event.isMarkedContinue();
        }
        return true;
    }
}

