/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom.effect;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxSection;
import com.btk5h.skriptmirror.skript.custom.SyntaxParseEvent;
import com.btk5h.skriptmirror.skript.custom.effect.CustomEffect;
import com.btk5h.skriptmirror.skript.custom.effect.EffectTriggerEvent;
import com.btk5h.skriptmirror.skript.custom.effect.SyntaxInfo;
import com.btk5h.skriptmirror.util.SkriptUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.MatchResult;

public class CustomEffectSection
extends CustomSyntaxSection<SyntaxInfo> {
    private static CustomSyntaxSection.DataTracker<SyntaxInfo> dataTracker;
    static final Map<SyntaxInfo, Trigger> effectHandlers;
    static final Map<SyntaxInfo, Trigger> parserHandlers;

    @Override
    public CustomSyntaxSection.DataTracker<SyntaxInfo> getDataTracker() {
        return dataTracker;
    }

    @Override
    protected boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult, SectionNode node) {
        SectionNode patterns = (SectionNode)node.get("patterns");
        File script = (parseResult.mark & 1) == 1 ? SkriptUtil.getCurrentScript() : null;
        switch (matchedPattern) {
            case 0: {
                this.register(SyntaxInfo.create(script, ((MatchResult)parseResult.regexes.get(0)).group()));
                break;
            }
            case 1: {
                if (patterns == null) {
                    Skript.error((String)"Custom effects without inline patterns must have a patterns section.");
                    return false;
                }
                patterns.forEach(subNode -> this.register(SyntaxInfo.create(script, subNode.getKey())));
            }
        }
        if (matchedPattern != 1 && patterns != null) {
            Skript.error((String)"Custom effects with inline patterns may not have a patterns section.");
            return false;
        }
        ScriptLoader.setCurrentEvent((String)"custom effect trigger", (Class[])new Class[]{EffectTriggerEvent.class});
        SkriptUtil.getItemsFromNode(node, "trigger").ifPresent(items -> this.whichInfo.forEach(which -> effectHandlers.put((SyntaxInfo)which, new Trigger(ScriptLoader.currentScript.getFile(), "effect " + which, (SkriptEvent)this, items))));
        SyntaxParseEvent.register(this, node, this.whichInfo, parserHandlers);
        return true;
    }

    public static SyntaxInfo lookup(File script, int matchedPattern) {
        return dataTracker.lookup(script, matchedPattern);
    }

    static {
        CustomSyntaxSection.register("Define Effect", CustomEffectSection.class, "[(1\u00a6local)] effect <.+>", "[(1\u00a6local)] effect");
        dataTracker = new CustomSyntaxSection.DataTracker();
        effectHandlers = new HashMap<SyntaxInfo, Trigger>();
        parserHandlers = new HashMap<SyntaxInfo, Trigger>();
        dataTracker.setSyntaxType("effect");
        dataTracker.getValidator().addSection("trigger", false).addSection("patterns", true).addSection("parse", true);
        Skript.registerEffect(CustomEffect.class, (String[])new String[0]);
        Optional<SyntaxElementInfo> info = Skript.getEffects().stream().filter(i -> i.c == CustomEffect.class).findFirst();
        info.ifPresent(dataTracker::setInfo);
        dataTracker.addManaged(effectHandlers);
        dataTracker.addManaged(parserHandlers);
    }
}

