/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom.effect;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.btk5h.skriptmirror.skript.custom.SyntaxParseEvent;
import com.btk5h.skriptmirror.skript.custom.effect.CustomEffectSection;
import com.btk5h.skriptmirror.skript.custom.effect.EffectTriggerEvent;
import com.btk5h.skriptmirror.skript.custom.effect.SyntaxInfo;
import com.btk5h.skriptmirror.util.SkriptReflection;
import com.btk5h.skriptmirror.util.SkriptUtil;
import java.util.Arrays;
import org.bukkit.event.Event;

public class CustomEffect
extends Effect {
    private SyntaxInfo which;
    private Expression<?>[] exprs;
    private int matchedPattern;
    private SkriptParser.ParseResult parseResult;
    private Event parseEvent;

    protected void execute(Event e) {
        this.invokeEffect(e);
    }

    protected TriggerItem walk(Event e) {
        EffectTriggerEvent effectEvent = this.invokeEffect(e);
        if (effectEvent.isSync()) {
            return this.getNext();
        }
        return null;
    }

    private EffectTriggerEvent invokeEffect(Event e) {
        Trigger trigger = CustomEffectSection.effectHandlers.get(this.which);
        EffectTriggerEvent effectEvent = new EffectTriggerEvent(e, this.exprs, this.matchedPattern, this.parseResult, this.which.getPattern(), this.getNext());
        if (trigger == null) {
            Skript.error((String)String.format("The custom effect '%s' no longer has a handler.", this.which));
        } else {
            SkriptReflection.copyVariablesMap(this.parseEvent, effectEvent);
            trigger.execute((Event)effectEvent);
        }
        return effectEvent;
    }

    public String toString(Event e, boolean debug) {
        return this.which.getPattern();
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.which = CustomEffectSection.lookup(SkriptUtil.getCurrentScript(), matchedPattern);
        if (this.which == null) {
            return false;
        }
        this.exprs = (Expression[])Arrays.stream(exprs).map(SkriptUtil::defendExpression).toArray(Expression[]::new);
        this.matchedPattern = matchedPattern;
        this.parseResult = parseResult;
        if (!SkriptUtil.canInitSafely(this.exprs)) {
            return false;
        }
        Trigger parseHandler = CustomEffectSection.parserHandlers.get(this.which);
        if (parseHandler != null) {
            SyntaxParseEvent event = new SyntaxParseEvent(this.exprs, matchedPattern, parseResult, ScriptLoader.getCurrentEvents());
            parseHandler.execute((Event)event);
            if (SkriptReflection.hasLocalVariables(event)) {
                this.parseEvent = event;
            }
            return event.isMarkedContinue();
        }
        return true;
    }
}

