/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom.condition;

import com.btk5h.skriptmirror.skript.custom.CustomSyntaxSection;
import com.btk5h.skriptmirror.util.SkriptMirrorUtil;
import java.io.File;
import java.util.Objects;

class SyntaxInfo
implements CustomSyntaxSection.SyntaxData {
    private final File script;
    private final String pattern;
    private final boolean inverted;
    private final boolean property;

    private SyntaxInfo(File script, String pattern, boolean inverted, boolean property) {
        this.script = script;
        this.pattern = pattern;
        this.inverted = inverted;
        this.property = property;
    }

    public static SyntaxInfo create(File script, String pattern, boolean inverted, boolean property) {
        return new SyntaxInfo(script, SkriptMirrorUtil.preprocessPattern(pattern), inverted, property);
    }

    @Override
    public File getScript() {
        return this.script;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public boolean isProperty() {
        return this.property;
    }

    public String toString() {
        return String.format("%s (inverted: %s, property: %s)", this.pattern, this.inverted, this.property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntaxInfo that = (SyntaxInfo)o;
        return this.inverted == that.inverted && Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.inverted);
    }
}

