/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom.expression;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import com.btk5h.skriptmirror.Util;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxSection;
import com.btk5h.skriptmirror.skript.custom.SyntaxParseEvent;
import com.btk5h.skriptmirror.skript.custom.expression.CustomExpression;
import com.btk5h.skriptmirror.skript.custom.expression.ExpressionChangeEvent;
import com.btk5h.skriptmirror.skript.custom.expression.ExpressionGetEvent;
import com.btk5h.skriptmirror.skript.custom.expression.SyntaxInfo;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.regex.MatchResult;
import java.util.stream.StreamSupport;

public class CustomExpressionSection
extends CustomSyntaxSection<SyntaxInfo> {
    private static CustomSyntaxSection.DataTracker<SyntaxInfo> dataTracker;
    static Map<SyntaxInfo, Class<?>> returnTypes;
    static Map<SyntaxInfo, Trigger> expressionHandlers;
    static Map<SyntaxInfo, Trigger> parserHandlers;
    static Map<SyntaxInfo, Map<Changer.ChangeMode, Trigger>> changerHandlers;

    @Override
    protected CustomSyntaxSection.DataTracker<SyntaxInfo> getDataTracker() {
        return dataTracker;
    }

    @Override
    protected boolean init(Literal[] args, int matchedPattern, SkriptParser.ParseResult parseResult, SectionNode node) {
        SectionNode patterns = (SectionNode)node.get("patterns");
        File script = (parseResult.mark & 2) == 2 ? Util.getCurrentScript() : null;
        switch (matchedPattern) {
            case 0: {
                String what = ((MatchResult)parseResult.regexes.get(0)).group();
                this.register(SyntaxInfo.create(script, what, (parseResult.mark & 1) == 1, false, false));
                break;
            }
            case 1: {
                if (patterns == null) {
                    Skript.error((String)"Custom expressions without inline patterns must have a patterns section.");
                    return false;
                }
                patterns.forEach(subNode -> this.register(SyntaxInfo.create(script, subNode.getKey(), (parseResult.mark & 1) == 1, false, false)));
                break;
            }
            case 2: {
                String what = ((MatchResult)parseResult.regexes.get(0)).group();
                String fromType = ((ClassInfo)args[0].getSingle()).getCodeName();
                this.register(SyntaxInfo.create(script, "[the] " + what + " of %$" + fromType + "s%", false, true, true));
                this.register(SyntaxInfo.create(script, "%$" + fromType + "s%'[s] " + what, false, false, true));
            }
        }
        if (matchedPattern != 1 && patterns != null) {
            Skript.error((String)"Custom expressions with inline patterns may not have a patterns section.");
            return false;
        }
        ScriptLoader.setCurrentEvent((String)"custom expression getter", (Class[])new Class[]{ExpressionGetEvent.class});
        Util.getItemsFromNode(node, "get").ifPresent(items -> this.whichInfo.forEach(which -> expressionHandlers.put((SyntaxInfo)which, new Trigger(ScriptLoader.currentScript.getFile(), "get " + which.getPattern(), (SkriptEvent)this, items))));
        SyntaxParseEvent.register(this, node, this.whichInfo, parserHandlers);
        Arrays.stream(Changer.ChangeMode.values()).forEach(mode -> {
            String name = mode.name().replace("_", " ").toLowerCase();
            ScriptLoader.setCurrentEvent((String)"custom expression changer", (Class[])new Class[]{ExpressionChangeEvent.class});
            Util.getItemsFromNode(node, name).ifPresent(items -> this.whichInfo.forEach(which -> {
                Map changerMap = changerHandlers.computeIfAbsent((SyntaxInfo)which, k -> new HashMap());
                changerMap.put(mode, new Trigger(ScriptLoader.currentScript.getFile(), String.format("%s %s", name, which.getPattern()), (SkriptEvent)this, items));
            }));
        });
        return true;
    }

    public static SyntaxInfo lookup(File script, int matchedPattern) {
        return dataTracker.lookup(script, matchedPattern);
    }

    static {
        CustomSyntaxSection.register("Define Expression", CustomExpressionSection.class, "[(2\u00a6local)] [(1\u00a6(plural|non(-|[ ])single))] expression <.+>", "[(2\u00a6local)] [(1\u00a6(plural|non(-|[ ])single))] expression", "[(2\u00a6local)] %*classinfo% property <.+>");
        dataTracker = new CustomSyntaxSection.DataTracker();
        returnTypes = new HashMap();
        expressionHandlers = new HashMap<SyntaxInfo, Trigger>();
        parserHandlers = new HashMap<SyntaxInfo, Trigger>();
        changerHandlers = new HashMap<SyntaxInfo, Map<Changer.ChangeMode, Trigger>>();
        dataTracker.setSyntaxType("expression");
        dataTracker.getValidator().addEntry("return type", true).addSection("get", true).addSection("patterns", true).addSection("parse", true);
        Arrays.stream(Changer.ChangeMode.values()).map(mode -> mode.name().replace("_", " ").toLowerCase()).forEach(mode -> dataTracker.getValidator().addSection(mode, true));
        Skript.registerExpression(CustomExpression.class, Object.class, (ExpressionType)ExpressionType.PATTERN_MATCHES_EVERYTHING, (String[])new String[0]);
        Optional<ExpressionInfo> info = StreamSupport.stream(Spliterators.spliteratorUnknownSize(Skript.getExpressions(), 16), false).filter(i -> i.c == CustomExpression.class).findFirst();
        info.ifPresent(dataTracker::setInfo);
        dataTracker.addManaged(returnTypes);
        dataTracker.addManaged(expressionHandlers);
        dataTracker.addManaged(changerHandlers);
        dataTracker.addManaged(parserHandlers);
    }
}

