/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.command.EffectCommandEvent;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import com.btk5h.skriptmirror.JavaType;
import com.btk5h.skriptmirror.LibraryLoader;
import com.btk5h.skriptmirror.Util;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxSection;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class CustomImport {
    private static Pattern IMPORT_STATEMENT = Pattern.compile("((?:[_a-zA-Z$][\\w$]*\\.)*(?:[_a-zA-Z$][\\w$]*))(?:\\s+as ([_a-zA-Z$][\\w$]*))?");
    private static SyntaxElementInfo<?> thisInfo;
    private static Map<File, Map<String, JavaType>> imports;

    private static void registerImport(String rawStatement, File script) {
        Class<?> javaClass;
        Matcher statement = IMPORT_STATEMENT.matcher(ScriptLoader.replaceOptions((String)rawStatement));
        if (!statement.matches()) {
            Skript.warning((String)(rawStatement + " is an invalid import statement."));
            return;
        }
        String cls = statement.group(1);
        try {
            javaClass = LibraryLoader.getClassLoader().loadClass(cls);
        }
        catch (ClassNotFoundException ex) {
            Skript.warning((String)(cls + " refers to a non-existent class."));
            return;
        }
        String importName = statement.group(2);
        if (importName == null) {
            importName = javaClass.getSimpleName();
        }
        imports.computeIfAbsent(script, s -> new HashMap()).compute(importName, (name, oldClass) -> {
            if (oldClass != null) {
                Skript.warning((String)String.format("%s is already mapped to %s. It will not be remapped to %s.", name, oldClass.getJavaClass(), javaClass));
                return oldClass;
            }
            return new JavaType(javaClass);
        });
        CustomImport.updateImports();
    }

    private static void updateImports() {
        String[] patterns = (String[])imports.values().stream().flatMap(m -> m.keySet().stream()).distinct().toArray(String[]::new);
        Util.setPatterns(thisInfo, patterns);
    }

    public static JavaType lookup(File script, String identifier) {
        Map<String, JavaType> localImports = imports.get(script);
        if (localImports == null) {
            return null;
        }
        return localImports.get(identifier);
    }

    static {
        CustomSyntaxSection.register("Import", SectionImport.class, "import");
        Skript.registerEffect(EffImport.class, (String[])new String[]{"import <" + IMPORT_STATEMENT.pattern() + ">"});
        Skript.registerExpression(ImportHandler.class, JavaType.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[0]);
        Optional<ExpressionInfo> info = StreamSupport.stream(Spliterators.spliteratorUnknownSize(Skript.getExpressions(), 16), false).filter(i -> i.c == ImportHandler.class).findFirst();
        if (info.isPresent()) {
            thisInfo = (SyntaxElementInfo)info.get();
        } else {
            Skript.warning((String)"Could not find custom import class. Custom imports will not work.");
        }
        imports = new HashMap<File, Map<String, JavaType>>();
    }

    public static class EffImport
    extends Effect {
        public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
            if (!ScriptLoader.isCurrentEvent(EffectCommandEvent.class)) {
                return false;
            }
            CustomImport.registerImport(((MatchResult)parseResult.regexes.get(0)).group(), null);
            return true;
        }

        public String toString(@Nullable Event e, boolean debug) {
            return "import";
        }

        protected void execute(Event e) {
        }
    }

    public static class ImportHandler
    extends SimpleExpression<JavaType> {
        private JavaType type;

        protected JavaType[] get(Event e) {
            return new JavaType[]{this.type};
        }

        public boolean isSingle() {
            return true;
        }

        public Class<? extends JavaType> getReturnType() {
            return JavaType.class;
        }

        public String toString(Event e, boolean debug) {
            return this.type.getJavaClass().getName();
        }

        public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
            Map localImports = (Map)imports.get(ScriptLoader.currentScript == null ? null : ScriptLoader.currentScript.getFile());
            if (localImports != null) {
                this.type = (JavaType)localImports.get(parseResult.expr);
            }
            return this.type != null;
        }
    }

    public static class SectionImport
    extends SelfRegisteringSkriptEvent {
        public void register(Trigger t) {
        }

        public void unregister(Trigger t) {
            imports.remove(t.getScript());
        }

        public void unregisterAll() {
            imports.clear();
        }

        public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
            File currentScript = ScriptLoader.currentScript.getFile();
            SectionNode node = (SectionNode)SkriptLogger.getNode();
            if (node.getKey().toLowerCase().startsWith("on ")) {
                return false;
            }
            node.forEach(subNode -> CustomImport.registerImport(subNode.getKey(), currentScript));
            Util.clearSectionNode(node);
            return true;
        }

        public String toString(Event e, boolean debug) {
            return "import";
        }
    }
}

