/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror;

import ch.njol.skript.registrations.Classes;
import com.btk5h.skriptmirror.Util;
import java.util.Arrays;

public class ObjectWrapper {
    protected Object object;

    private ObjectWrapper(Object object) {
        this.object = object;
    }

    public static ObjectWrapper create(Object object) {
        if (object.getClass().isArray()) {
            return new OfArray((Object[])object);
        }
        return new ObjectWrapper(object);
    }

    public static Object wrapIfNecessary(Object returnedValue) {
        Class<?> returnedClass = returnedValue.getClass();
        if (returnedClass.isArray()) {
            returnedValue = ObjectWrapper.create(Util.boxPrimitiveArray(returnedValue));
        } else if (Classes.getSuperClassInfo(returnedClass).getC() == Object.class) {
            returnedValue = ObjectWrapper.create(returnedValue);
        }
        return returnedValue;
    }

    public Object get() {
        return this.object;
    }

    public String toString() {
        return this.object.toString();
    }

    public static class OfArray
    extends ObjectWrapper {
        private OfArray(Object[] object) {
            super(object);
        }

        public Object[] get() {
            return (Object[])this.object;
        }

        @Override
        public String toString() {
            return Arrays.deepToString(this.get());
        }
    }
}

