/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import com.btk5h.skriptmirror.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.event.Event;

public abstract class CustomSyntaxSection<T extends SyntaxData>
extends SelfRegisteringSkriptEvent {
    protected final List<T> whichInfo = new ArrayList<T>();

    public static <E extends SkriptEvent> SkriptEventInfo<E> register(String name, Class<E> c, String ... patterns) {
        return Skript.registerEvent((String)("*" + name), c, (Class[])new Class[0], (String[])patterns);
    }

    protected abstract DataTracker<T> getDataTracker();

    public void register(Trigger t) {
    }

    public void unregister(Trigger t) {
        this.whichInfo.forEach(which -> {
            Map<File, Map<String, T>> primaryData = this.getDataTracker().getPrimaryData();
            File script = which.getScript();
            Map<String, T> syntaxes = primaryData.get(script);
            syntaxes.remove(which.getPattern());
            if (syntaxes.size() == 0) {
                primaryData.remove(script);
            }
            this.getDataTracker().getManagedData().forEach(data -> data.remove(which));
        });
        this.update();
    }

    public void unregisterAll() {
        this.getDataTracker().getPatterns().clear();
        this.getDataTracker().getPrimaryData().clear();
        this.getDataTracker().getManagedData().forEach(Map::clear);
        this.update();
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        SectionNode node = (SectionNode)SkriptLogger.getNode();
        node.convertToEntries(0);
        if (!this.getDataTracker().getValidator().validate((Node)node)) {
            return false;
        }
        boolean ok = this.init(args, matchedPattern, parseResult, node);
        if (!ok) {
            this.unregister(null);
        }
        Util.clearSectionNode(node);
        this.update();
        return ok;
    }

    protected abstract boolean init(Literal<?>[] var1, int var2, SkriptParser.ParseResult var3, SectionNode var4);

    public String toString(Event e, boolean debug) {
        return null;
    }

    private void update() {
        this.getDataTracker().recomputePatterns();
        Util.setPatterns(this.getDataTracker().getInfo(), this.getDataTracker().getPatterns().toArray(new String[0]));
    }

    protected final void register(T data) {
        String pattern = data.getPattern();
        this.whichInfo.add(data);
        this.getDataTracker().getPrimaryData().computeIfAbsent(data.getScript(), f -> new HashMap()).put(pattern, data);
    }

    public static interface SyntaxData {
        public File getScript();

        public String getPattern();
    }

    public static class DataTracker<T> {
        private final SectionValidator validator = new SectionValidator();
        private List<String> patterns = new ArrayList<String>();
        private final Map<File, Map<String, T>> primaryData = new HashMap<File, Map<String, T>>();
        private final List<Map<T, ?>> managedData = new ArrayList();
        private String syntaxType = "syntax";
        private SyntaxElementInfo<?> info;

        public SectionValidator getValidator() {
            return this.validator;
        }

        public List<String> getPatterns() {
            return this.patterns;
        }

        public Map<File, Map<String, T>> getPrimaryData() {
            return this.primaryData;
        }

        public List<Map<T, ?>> getManagedData() {
            return this.managedData;
        }

        public String getSyntaxType() {
            return this.syntaxType;
        }

        public SyntaxElementInfo<?> getInfo() {
            return this.info;
        }

        public void recomputePatterns() {
            this.patterns = this.primaryData.entrySet().stream().map(Map.Entry::getValue).map(Map::keySet).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }

        public void addManaged(Map<T, ?> data) {
            this.managedData.add(data);
        }

        public void setSyntaxType(String syntaxType) {
            this.syntaxType = syntaxType;
        }

        public void setInfo(SyntaxElementInfo<?> info) {
            this.info = info;
        }

        public final T lookup(File script, int matchedPattern) {
            T privateResult;
            String originalSyntax = this.patterns.get(matchedPattern);
            Map<String, T> localSyntax = this.primaryData.get(script);
            if (localSyntax != null && (privateResult = localSyntax.get(originalSyntax)) != null) {
                return privateResult;
            }
            Map<String, T> globalSyntax = this.primaryData.get(null);
            if (globalSyntax == null || !globalSyntax.containsKey(originalSyntax)) {
                return null;
            }
            return globalSyntax.get(originalSyntax);
        }
    }
}

