/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror;

import com.btk5h.skriptmirror.LibraryLoader;
import com.btk5h.skriptmirror.Util;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Descriptor {
    private static final String IDENTIFIER = "[_a-zA-Z$][\\w$]*";
    private static final String PACKAGE = "(?:[_a-zA-Z$][\\w$]*\\.)*(?:[_a-zA-Z$][\\w$]*)";
    private static final Pattern DESCRIPTOR = Pattern.compile("(?:\\[((?:[_a-zA-Z$][\\w$]*\\.)*(?:[_a-zA-Z$][\\w$]*))])?([_a-zA-Z$][\\w$]*)(?:\\[((?:(?:[_a-zA-Z$][\\w$]*\\.)*(?:[_a-zA-Z$][\\w$]*)\\s*,\\s*)*(?:(?:[_a-zA-Z$][\\w$]*\\.)*(?:[_a-zA-Z$][\\w$]*)))])?");
    private final Class<?> javaClass;
    private final String name;
    private final Class<?>[] parameterTypes;

    public Descriptor(Class<?> javaClass, String name, Class<?>[] parameterTypes) {
        this.javaClass = javaClass;
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return Objects.equals(this.javaClass, that.javaClass) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.javaClass, this.name);
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public String getName() {
        return this.name;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String toString() {
        return String.format("%s#%s", this.javaClass == null ? "(unspecified)" : Util.getDebugName(this.javaClass), this.name);
    }

    public static Descriptor parse(String desc) throws ClassNotFoundException {
        Matcher m = DESCRIPTOR.matcher(desc);
        if (m.matches()) {
            String cls = m.group(1);
            String name = m.group(2);
            String args = m.group(3);
            Class<?> javaClass = null;
            Class<?>[] parameterTypes = null;
            if (cls != null) {
                javaClass = LibraryLoader.getClassLoader().loadClass(cls);
            }
            if (args != null) {
                parameterTypes = Descriptor.parseParams(args);
            }
            return new Descriptor(javaClass, name, parameterTypes);
        }
        return null;
    }

    private static Class<?>[] parseParams(String args) throws ClassNotFoundException {
        String[] rawClasses = args.split(",");
        Class[] parsedClasses = new Class[rawClasses.length];
        for (int i = 0; i < rawClasses.length; ++i) {
            String userType = rawClasses[i];
            String normalType = userType.trim();
            Class<?> cls = Util.PRIMITIVE_CLASS_NAMES.get(normalType);
            if (cls == null) {
                cls = LibraryLoader.getClassLoader().loadClass(normalType);
            }
            parsedClasses[i] = cls;
        }
        return parsedClasses;
    }
}

