/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom.expression;

import com.btk5h.skriptmirror.skript.custom.CustomSyntaxSection;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

class SyntaxInfo
implements CustomSyntaxSection.SyntaxData {
    private final File script;
    private final String pattern;
    private final int[] inheritedSingles;
    private final boolean alwaysPlural;
    private final boolean adaptArgument;
    private final boolean property;

    private SyntaxInfo(File script, String pattern, int[] inheritedSingles, boolean alwaysPlural, boolean adaptArgument, boolean property) {
        this.script = script;
        this.pattern = pattern;
        this.inheritedSingles = inheritedSingles;
        this.alwaysPlural = alwaysPlural;
        this.adaptArgument = adaptArgument;
        this.property = property;
    }

    public static SyntaxInfo create(File script, String pattern, boolean alwaysPlural, boolean adaptArgument, boolean property) {
        StringBuilder newPattern = new StringBuilder(pattern.length());
        ArrayList<Integer> inheritedSingles = new ArrayList<Integer>();
        String[] parts = pattern.split("%");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            if (i2 % 2 == 0) {
                newPattern.append(part);
                continue;
            }
            if (part.startsWith("$")) {
                part = part.substring(1);
                inheritedSingles.add(i2 / 2);
            }
            if (part.startsWith("_")) {
                part = part.endsWith("s") ? "objects" : "object";
            }
            newPattern.append('%');
            newPattern.append(part);
            newPattern.append('%');
        }
        return new SyntaxInfo(script, newPattern.toString(), inheritedSingles.stream().mapToInt(i -> i).toArray(), alwaysPlural, adaptArgument, property);
    }

    @Override
    public File getScript() {
        return this.script;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public int[] getInheritedSingles() {
        return this.inheritedSingles;
    }

    public boolean isAlwaysPlural() {
        return this.alwaysPlural;
    }

    public boolean shouldAdaptArgument() {
        return this.adaptArgument;
    }

    public boolean isProperty() {
        return this.property;
    }

    public String toString() {
        return String.format("%s (singles: %s, plural: %s, adapt: %s, property: %s)", this.pattern, Arrays.toString(this.inheritedSingles), this.alwaysPlural, this.adaptArgument, this.property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntaxInfo that = (SyntaxInfo)o;
        return this.alwaysPlural == that.alwaysPlural && this.adaptArgument == that.adaptArgument && Objects.equals(this.pattern, that.pattern) && Arrays.equals(this.inheritedSingles, that.inheritedSingles);
    }

    public int hashCode() {
        int result = Objects.hash(this.pattern, this.alwaysPlural, this.adaptArgument);
        result = 31 * result + Arrays.hashCode(this.inheritedSingles);
        return result;
    }
}

