/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom.condition;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import com.btk5h.skriptmirror.Util;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxSection;
import com.btk5h.skriptmirror.skript.custom.SyntaxParseEvent;
import com.btk5h.skriptmirror.skript.custom.condition.ConditionCheckEvent;
import com.btk5h.skriptmirror.skript.custom.condition.CustomCondition;
import com.btk5h.skriptmirror.skript.custom.condition.SyntaxInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.MatchResult;

public class CustomConditionSection
extends CustomSyntaxSection<SyntaxInfo> {
    private static CustomSyntaxSection.DataTracker<SyntaxInfo> dataTracker;
    static Map<SyntaxInfo, Trigger> conditionHandlers;
    static Map<SyntaxInfo, Trigger> parserHandlers;

    @Override
    public CustomSyntaxSection.DataTracker<SyntaxInfo> getDataTracker() {
        return dataTracker;
    }

    @Override
    protected boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult, SectionNode node) {
        SectionNode patterns = (SectionNode)node.get("patterns");
        File script = (parseResult.mark & 1) == 1 ? Util.getCurrentScript() : null;
        switch (matchedPattern) {
            case 0: {
                String what = ((MatchResult)parseResult.regexes.get(0)).group();
                this.register(SyntaxInfo.create(script, what, false, false));
                break;
            }
            case 1: {
                if (patterns == null) {
                    Skript.error((String)"Custom conditions without inline patterns must have a patterns section.");
                    return false;
                }
                patterns.forEach(subNode -> this.register(SyntaxInfo.create(script, subNode.getKey(), false, false)));
                break;
            }
            case 2: {
                String what = ((MatchResult)parseResult.regexes.get(0)).group();
                String type = ((ClassInfo)args[0].getSingle()).getCodeName();
                this.register(SyntaxInfo.create(script, "%" + type + "% (is|are) " + what, false, true));
                this.register(SyntaxInfo.create(script, "%" + type + "% (isn't|is not|aren't|are not) " + what, true, true));
            }
        }
        if (matchedPattern != 1 && patterns != null) {
            Skript.error((String)"Custom conditions with inline patterns may not have a patterns section.");
            return false;
        }
        ScriptLoader.setCurrentEvent((String)"custom condition check", (Class[])new Class[]{ConditionCheckEvent.class});
        Util.getItemsFromNode(node, "check").ifPresent(items -> this.whichInfo.forEach(which -> conditionHandlers.put((SyntaxInfo)which, new Trigger(ScriptLoader.currentScript.getFile(), "condition " + which, (SkriptEvent)this, items))));
        SyntaxParseEvent.register(this, node, this.whichInfo, parserHandlers);
        return true;
    }

    public static SyntaxInfo lookup(File script, int matchedPattern) {
        return dataTracker.lookup(script, matchedPattern);
    }

    static {
        CustomSyntaxSection.register("Define Condition", CustomConditionSection.class, "[(1\u00a6local)] condition <.+>", "[(1\u00a6local)] condition", "[(1\u00a6local)] %*classinfo% property condition <.+>");
        dataTracker = new CustomSyntaxSection.DataTracker();
        conditionHandlers = new HashMap<SyntaxInfo, Trigger>();
        parserHandlers = new HashMap<SyntaxInfo, Trigger>();
        dataTracker.setSyntaxType("condition");
        dataTracker.getValidator().addSection("check", false).addSection("parse", true);
        Skript.registerCondition(CustomCondition.class, (String[])new String[0]);
        Optional<SyntaxElementInfo> info = Skript.getConditions().stream().filter(i -> i.c == CustomCondition.class).findFirst();
        info.ifPresent(dataTracker::setInfo);
        dataTracker.addManaged(conditionHandlers);
        dataTracker.addManaged(parserHandlers);
    }
}

