/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import com.btk5h.skriptmirror.Util;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.MatchResult;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class CustomCondition {
    private static SyntaxElementInfo<?> thisInfo;
    private static final SectionValidator CONDITION_DECLARATION;
    private static List<String> conditions;
    private static Map<String, SyntaxInfo> conditionInfos;
    private static Map<SyntaxInfo, Trigger> conditionHandlers;

    private static SyntaxInfo createSyntaxInfo(String pattern, boolean inverted, boolean property) {
        return new SyntaxInfo(Util.preprocessPattern(pattern), inverted, property);
    }

    private static void updateConditions() {
        Util.setPatterns(thisInfo, conditions.toArray(new String[0]));
    }

    static {
        Skript.registerEvent((String)"*Define Condition", EventHandler.class, ConditionEvent.class, (String[])new String[]{"condition <.+>", "%*classinfo% property condition <.+>"});
        Skript.registerCondition(ConditionHandler.class, (String[])new String[0]);
        Optional<SyntaxElementInfo> info = Skript.getConditions().stream().filter(i -> i.c == ConditionHandler.class).findFirst();
        if (info.isPresent()) {
            thisInfo = info.get();
        } else {
            Skript.warning((String)"Could not find custom condition class. Custom conditions will not work.");
        }
        CONDITION_DECLARATION = new SectionValidator().addSection("check", false);
        conditions = new ArrayList<String>();
        conditionInfos = new HashMap<String, SyntaxInfo>();
        conditionHandlers = new HashMap<SyntaxInfo, Trigger>();
    }

    public static class ConditionHandler
    extends Condition {
        private SyntaxInfo which;
        private Expression<?>[] exprs;
        private SkriptParser.ParseResult parseResult;

        public boolean check(Event e) {
            Trigger checker = (Trigger)conditionHandlers.get(this.which);
            if (checker == null) {
                Skript.error((String)String.format("The custom condtion '%s' no longer has a check handler.", this.which.getPattern()));
                return false;
            }
            if (this.which.isProperty()) {
                return this.checkByProperty(e, checker);
            }
            return this.checkByStandard(e, checker);
        }

        private boolean checkByStandard(Event e, Trigger checker) {
            ConditionEvent conditionEvent = new ConditionEvent(e, this.exprs, this.parseResult);
            checker.execute((Event)conditionEvent);
            return conditionEvent.isMarkedContinue() ^ conditionEvent.isMarkedNegated() ^ this.which.isInverted();
        }

        private boolean checkByProperty(Event e, Trigger checker) {
            return this.exprs[0].check(e, o -> {
                Expression<?>[] localExprs = Arrays.copyOf(this.exprs, this.exprs.length);
                localExprs[0] = new SimpleLiteral(o, false);
                ConditionEvent conditionEvent = new ConditionEvent(e, localExprs, this.parseResult);
                checker.execute((Event)conditionEvent);
                return conditionEvent.isMarkedContinue() ^ conditionEvent.isMarkedNegated();
            }, this.which.isInverted());
        }

        public String toString(Event e, boolean debug) {
            return this.which.getPattern();
        }

        public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
            String pattern = (String)conditions.get(matchedPattern);
            this.which = (SyntaxInfo)conditionInfos.get(pattern);
            this.exprs = (Expression[])Arrays.stream(exprs).map(Util::defendExpression).toArray(Expression[]::new);
            this.parseResult = parseResult;
            return Util.canInitSafely(this.exprs);
        }
    }

    public static class EventHandler
    extends SelfRegisteringSkriptEvent {
        private List<SyntaxInfo> whiches = new ArrayList<SyntaxInfo>();

        public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
            String c = ((MatchResult)parseResult.regexes.get(0)).group();
            switch (matchedPattern) {
                case 0: {
                    this.whiches.add(CustomCondition.createSyntaxInfo(c, false, false));
                    break;
                }
                case 1: {
                    String type = ((ClassInfo)args[0].getSingle()).getCodeName();
                    this.whiches.add(CustomCondition.createSyntaxInfo("%" + type + "% (is|are) " + c, false, true));
                    this.whiches.add(CustomCondition.createSyntaxInfo("%" + type + "% (isn't|is not|aren't|are not) " + c, true, true));
                }
            }
            this.whiches.forEach(which -> {
                String pattern = which.getPattern();
                if (!conditions.contains(pattern)) {
                    conditions.add(pattern);
                    conditionInfos.put(pattern, which);
                } else {
                    Skript.error((String)String.format("The custom condition '%s' already has a handler.", pattern));
                }
            });
            SectionNode node = (SectionNode)SkriptLogger.getNode();
            boolean ok = CONDITION_DECLARATION.validate((Node)node);
            if (!ok) {
                this.unregister(null);
                return false;
            }
            this.register(node);
            return true;
        }

        private void register(SectionNode node) {
            node.convertToEntries(0);
            ScriptLoader.setCurrentEvent((String)"custom condition check", (Class[])new Class[]{ConditionEvent.class});
            Util.getItemsFromNode(node, "check").ifPresent(items -> this.whiches.forEach(which -> conditionHandlers.put(which, new Trigger(ScriptLoader.currentScript.getFile(), "condition " + which, (SkriptEvent)this, items))));
            Util.clearSectionNode(node);
            CustomCondition.updateConditions();
        }

        public void register(Trigger t) {
        }

        public void unregister(Trigger t) {
            this.whiches.forEach(which -> {
                conditions.remove(which.getPattern());
                conditionInfos.remove(which.getPattern());
                conditionHandlers.remove(which);
            });
            CustomCondition.updateConditions();
        }

        public void unregisterAll() {
            conditions.clear();
            conditionInfos.clear();
            conditionHandlers.clear();
            CustomCondition.updateConditions();
        }

        public String toString(Event e, boolean debug) {
            return "conditions: " + this.whiches.toString();
        }
    }

    public static class ConditionEvent
    extends CustomSyntaxEvent {
        private static final HandlerList handlers = new HandlerList();
        private boolean markedContinue;
        private boolean markedNegated;

        public ConditionEvent(Event event, Expression<?>[] expressions, SkriptParser.ParseResult parseResult) {
            super(event, expressions, parseResult);
        }

        public static HandlerList getHandlerList() {
            return handlers;
        }

        public boolean isMarkedContinue() {
            return this.markedContinue;
        }

        public boolean isMarkedNegated() {
            return this.markedNegated;
        }

        public void markContinue() {
            this.markedContinue = true;
        }

        public void markNegated() {
            this.markedNegated = true;
        }

        public HandlerList getHandlers() {
            return handlers;
        }
    }

    private static class SyntaxInfo {
        private final String pattern;
        private final boolean inverted;
        private final boolean property;

        private SyntaxInfo(String pattern, boolean inverted, boolean property) {
            this.pattern = pattern;
            this.inverted = inverted;
            this.property = property;
        }

        public String getPattern() {
            return this.pattern;
        }

        public boolean isInverted() {
            return this.inverted;
        }

        public boolean isProperty() {
            return this.property;
        }

        public String toString() {
            return String.format("%s (inverted: %s, property: %s)", this.pattern, this.inverted, this.property);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SyntaxInfo that = (SyntaxInfo)o;
            return this.inverted == that.inverted && Objects.equals(this.pattern, that.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.pattern, this.inverted);
        }
    }
}

