/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import com.btk5h.skriptmirror.LibraryLoader;
import com.btk5h.skriptmirror.SkriptMirror;
import com.btk5h.skriptmirror.WrappedEvent;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.MatchResult;
import org.bukkit.Bukkit;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class EvtByReflection
extends SkriptEvent {
    private static EventExecutor executor;
    private static PriorityListener[] listeners;
    private Class<? extends Event>[] classes;
    private EventPriority priority;

    private static void registerEvent(Class<? extends Event> event, EventPriority priority, boolean ignoreCancelled) {
        PriorityListener listener = listeners[priority.ordinal()];
        Set<Class<? extends Event>> events = listener.getEvents();
        if (!events.contains(event)) {
            events.add(event);
            Bukkit.getPluginManager().registerEvent(event, (Listener)listener, priority, executor, (Plugin)SkriptMirror.getInstance(), ignoreCancelled);
        }
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        String[] events = (String[])args[0].getArray();
        this.classes = (Class[])Array.newInstance(Class.class, events.length);
        for (int i = 0; i < events.length; ++i) {
            String event = events[i];
            try {
                Class<?> eventClass = LibraryLoader.getClassLoader().loadClass(event);
                if (!Event.class.isAssignableFrom(eventClass)) {
                    Skript.error((String)(event + " is not an event."));
                    return false;
                }
                this.classes[i] = eventClass;
                continue;
            }
            catch (ClassNotFoundException e) {
                Skript.error((String)(event + " refers to a non-existent class."));
                return false;
            }
        }
        if (parseResult.regexes.size() > 0) {
            String priorityName = ((MatchResult)parseResult.regexes.get(0)).group().toUpperCase();
            try {
                this.priority = EventPriority.valueOf((String)priorityName);
            }
            catch (IllegalArgumentException ex) {
                Skript.error((String)(priorityName + " is not a valid priority level."));
                return false;
            }
        } else {
            this.priority = (EventPriority)SkriptConfig.defaultEventPriority.value();
        }
        boolean ignoreCancelled = (parseResult.mark & 1) == 1;
        for (Class<? extends Event> cls : this.classes) {
            EvtByReflection.registerEvent(cls, this.priority, ignoreCancelled);
        }
        return true;
    }

    public boolean check(Event e) {
        Class<?> eventClass = ((BukkitEvent)e).getEvent().getClass();
        if (this.priority == ((BukkitEvent)e).getPriority()) {
            for (Class<? extends Event> cls : this.classes) {
                if (cls != eventClass) continue;
                return true;
            }
        }
        return false;
    }

    public String toString(Event e, boolean debug) {
        return Arrays.toString(this.classes) + " priority " + this.priority;
    }

    static {
        Skript.registerEvent((String)"Bukkit Event", EvtByReflection.class, BukkitEvent.class, (String[])new String[]{"[(1\u00a6all)] %strings% [(at|on|with) priority <.+>]"});
        executor = (listener, event) -> Bukkit.getPluginManager().callEvent((Event)new BukkitEvent(event, ((PriorityListener)listener).getPriority()));
        listeners = (PriorityListener[])Arrays.stream(EventPriority.values()).mapToInt(Enum::ordinal).mapToObj(PriorityListener::new).toArray(PriorityListener[]::new);
    }

    private static class BukkitEvent
    extends WrappedEvent
    implements Cancellable {
        private static final HandlerList handlers = new HandlerList();
        private final EventPriority priority;

        public BukkitEvent(Event event, EventPriority priority) {
            super(event);
            this.priority = priority;
        }

        public EventPriority getPriority() {
            return this.priority;
        }

        public static HandlerList getHandlerList() {
            return handlers;
        }

        public HandlerList getHandlers() {
            return handlers;
        }

        public boolean isCancelled() {
            Event event = this.getEvent();
            return this.getEvent() instanceof Cancellable && ((Cancellable)event).isCancelled();
        }

        public void setCancelled(boolean cancel) {
            Event event = this.getEvent();
            if (event instanceof Cancellable) {
                ((Cancellable)event).setCancelled(cancel);
            }
        }
    }

    private static class PriorityListener
    implements Listener {
        private EventPriority priority;
        private Set<Class<? extends Event>> events = new HashSet<Class<? extends Event>>();

        public PriorityListener(int priority) {
            this.priority = EventPriority.values()[priority];
        }

        public EventPriority getPriority() {
            return this.priority;
        }

        public Set<Class<? extends Event>> getEvents() {
            return this.events;
        }
    }
}

