/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript.custom;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import com.btk5h.skriptmirror.Util;
import com.btk5h.skriptmirror.skript.custom.CustomSyntaxEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.MatchResult;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class CustomEffect {
    private static SyntaxElementInfo<?> thisInfo;
    private static final SectionValidator EFFECT_DECLARATION;
    private static List<String> effects;
    private static Map<String, Trigger> effectHandlers;

    private static void updateEffects() {
        Util.setPatterns(thisInfo, effects.toArray(new String[0]));
    }

    static {
        Skript.registerEvent((String)"*Define Effect", EventHandler.class, EffectEvent.class, (String[])new String[]{"effect <.+>"});
        Skript.registerEffect(EffectHandler.class, (String[])new String[0]);
        Optional<SyntaxElementInfo> info = Skript.getEffects().stream().filter(i -> i.c == EffectHandler.class).findFirst();
        if (info.isPresent()) {
            thisInfo = info.get();
        } else {
            Skript.warning((String)"Could not find custom effect class. Custom effects will not work.");
        }
        EFFECT_DECLARATION = new SectionValidator().addSection("trigger", false);
        effects = new ArrayList<String>();
        effectHandlers = new HashMap<String, Trigger>();
    }

    public static class EffectHandler
    extends Effect {
        private String which;
        private Expression<?>[] exprs;
        private SkriptParser.ParseResult parseResult;

        protected void execute(Event e) {
            this.invokeEffect(e);
        }

        protected TriggerItem walk(Event e) {
            EffectEvent effectEvent = this.invokeEffect(e);
            if (effectEvent.isSync()) {
                return this.getNext();
            }
            return null;
        }

        private EffectEvent invokeEffect(Event e) {
            Trigger trigger = (Trigger)effectHandlers.get(this.which);
            EffectEvent effectEvent = new EffectEvent(e, this.exprs, this.parseResult, this.which, this.getNext());
            if (trigger == null) {
                Skript.error((String)String.format("The custom effect '%s' no longer has a handler.", this.which));
            } else {
                trigger.execute((Event)effectEvent);
            }
            return effectEvent;
        }

        public String toString(Event e, boolean debug) {
            return this.which;
        }

        public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
            this.which = (String)effects.get(matchedPattern);
            this.exprs = (Expression[])Arrays.stream(exprs).map(Util::defendExpression).toArray(Expression[]::new);
            this.parseResult = parseResult;
            return Util.canInitSafely(this.exprs);
        }
    }

    public static class EventHandler
    extends SelfRegisteringSkriptEvent {
        private String which;

        public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
            this.which = Util.preprocessPattern(((MatchResult)parseResult.regexes.get(0)).group());
            if (effects.contains(this.which)) {
                Skript.error((String)String.format("The custom effect '%s' already has a handler.", this.which));
                return false;
            }
            effects.add(this.which);
            SectionNode node = (SectionNode)SkriptLogger.getNode();
            boolean ok = EFFECT_DECLARATION.validate((Node)node);
            if (!ok) {
                this.unregister(null);
                return false;
            }
            this.register(node);
            return true;
        }

        private void register(SectionNode node) {
            node.convertToEntries(0);
            ScriptLoader.setCurrentEvent((String)"custom efffect trigger", (Class[])new Class[]{EffectEvent.class});
            Util.getItemsFromNode(node, "trigger").ifPresent(items -> effectHandlers.put(this.which, new Trigger(ScriptLoader.currentScript.getFile(), "effect " + this.which, (SkriptEvent)this, items)));
            Util.clearSectionNode(node);
            CustomEffect.updateEffects();
        }

        public void register(Trigger t) {
        }

        public void unregister(Trigger t) {
            effects.remove(this.which);
            effectHandlers.remove(this.which);
            CustomEffect.updateEffects();
        }

        public void unregisterAll() {
            effects.clear();
            effectHandlers.clear();
            CustomEffect.updateEffects();
        }

        public String toString(Event e, boolean debug) {
            return this.which;
        }
    }

    public static class EffectEvent
    extends CustomSyntaxEvent {
        private static final HandlerList handlers = new HandlerList();
        private final String which;
        private final TriggerItem next;
        private boolean sync = true;

        public EffectEvent(Event event, Expression<?>[] expressions, SkriptParser.ParseResult parseResult, String which, TriggerItem next) {
            super(event, expressions, parseResult);
            this.which = which;
            this.next = next;
        }

        public String getWhich() {
            return this.which;
        }

        public TriggerItem getNext() {
            return this.next;
        }

        public boolean isSync() {
            return this.sync;
        }

        public void setSync(boolean sync) {
            this.sync = sync;
        }

        public static HandlerList getHandlerList() {
            return handlers;
        }

        public HandlerList getHandlers() {
            return handlers;
        }
    }
}

