/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.ArrayIterator;
import com.btk5h.skriptmirror.ArrayWrapper;
import com.btk5h.skriptmirror.Descriptor;
import com.btk5h.skriptmirror.JavaType;
import com.btk5h.skriptmirror.LRUCache;
import com.btk5h.skriptmirror.Null;
import com.btk5h.skriptmirror.Util;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.event.Event;

public class ExprJavaCall<T>
implements Expression<T> {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final Object[] NO_ARGS = new Object[0];
    private static final Descriptor CONSTRUCTOR_DESCRIPTOR = Descriptor.create("<init>");
    static String lastErrorMessage;
    static Throwable lastError;
    private LRUCache<Descriptor, Collection<MethodHandle>> callSiteCache = new LRUCache(8);
    private Expression<Object> targetArg;
    private Expression<Object> args;
    private Type type;
    private boolean isDynamic;
    private boolean suppressErrors = false;
    private Descriptor staticDescriptor;
    private Expression<String> dynamicDescriptor;
    private final ExprJavaCall<?> source;
    private final Class<? extends T>[] types;
    private final Class<T> superType;

    public ExprJavaCall() {
        this(null, Object.class);
    }

    @SafeVarargs
    private ExprJavaCall(ExprJavaCall<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.targetArg = source.targetArg;
            this.args = source.args;
            this.type = source.type;
            this.suppressErrors = source.suppressErrors;
            this.staticDescriptor = source.staticDescriptor;
            this.dynamicDescriptor = source.dynamicDescriptor;
        }
        this.types = types;
        this.superType = Utils.getSuperType((Class[])types);
    }

    private Collection<MethodHandle> getCallSite(Descriptor e) {
        return this.callSiteCache.computeIfAbsent(e, this::createCallSite);
    }

    private Collection<MethodHandle> createCallSite(Descriptor e) {
        Class<?> javaClass = e.getJavaClass();
        switch (this.type) {
            case FIELD: {
                return Util.fields(javaClass).filter(f -> f.getName().equals(e.getIdentifier())).peek(f -> f.setAccessible(true)).flatMap(Util.propagateErrors(f -> Stream.of(LOOKUP.unreflectGetter((Field)f), LOOKUP.unreflectSetter((Field)f)))).filter(Objects::nonNull).limit(2L).collect(Collectors.toList());
            }
            case METHOD: {
                return Util.methods(javaClass).filter(m -> m.getName().equals(e.getIdentifier())).peek(m -> m.setAccessible(true)).map(Util.propagateErrors(LOOKUP::unreflect)).filter(Objects::nonNull).collect(Collectors.toList());
            }
            case CONSTRUCTOR: {
                return Util.constructor(javaClass).peek(c -> c.setAccessible(true)).map(Util.propagateErrors(LOOKUP::unreflectConstructor)).filter(Objects::nonNull).collect(Collectors.toList());
            }
        }
        throw new IllegalStateException();
    }

    private static MethodHandle asSpreader(MethodHandle mh) {
        int paramCount = mh.type().parameterCount();
        if (mh.isVarargsCollector()) {
            if (paramCount == 1) {
                return mh;
            }
            return mh.asSpreader(Object[].class, paramCount - 1);
        }
        return mh.asSpreader(Object[].class, paramCount);
    }

    private T[] invoke(Object target, Object[] arguments, Descriptor baseDescriptor) {
        Object converted;
        Object returnedValue = null;
        Class<?> targetClass = Util.toClass(target);
        if (baseDescriptor == null) {
            return Util.newArray(this.superType, 0);
        }
        Descriptor descriptor = ExprJavaCall.specifyDescriptor(baseDescriptor, targetClass);
        if (descriptor.getJavaClass().isAssignableFrom(targetClass)) {
            Object[] arr;
            if (target instanceof JavaType) {
                arr = new Object[arguments.length];
                System.arraycopy(arguments, 0, arr, 0, arguments.length);
            } else {
                arr = new Object[arguments.length + 1];
                arr[0] = target;
                System.arraycopy(arguments, 0, arr, 1, arguments.length);
            }
            Optional<MethodHandle> method = this.selectMethod(descriptor, arr);
            if (method.isPresent()) {
                MethodHandle mh = method.get();
                ExprJavaCall.convertTypes(mh.type(), arr);
                try {
                    returnedValue = mh.invokeWithArguments(arr);
                }
                catch (Throwable throwable) {
                    lastError = throwable;
                    if (!this.suppressErrors) {
                        Skript.warning((String)String.format("%s %s%s threw a %s: %s%n", new Object[]{this.type, descriptor, this.optionalArgs(arguments), throwable.getClass().getSimpleName(), throwable.getMessage()}));
                    }
                }
            } else {
                lastErrorMessage = String.format("No matching %s: %s%s", new Object[]{this.type, descriptor, this.optionalArgs(arguments)});
                if (!this.suppressErrors) {
                    Skript.warning((String)lastErrorMessage);
                }
            }
        } else {
            lastErrorMessage = String.format("Incompatible %s call: %s on %s", new Object[]{this.type, descriptor, Util.getDebugName(targetClass)});
            if (!this.suppressErrors) {
                Skript.warning((String)lastErrorMessage);
            }
        }
        if (returnedValue == null) {
            return Util.newArray(this.superType, 0);
        }
        if ((this.superType == Object.class || this.superType == ArrayWrapper.class) && returnedValue.getClass().isArray()) {
            returnedValue = new ArrayWrapper((Object[])returnedValue);
        }
        if ((converted = Converters.convert((Object)returnedValue, (Class[])this.types)) == null) {
            String toClasses = Arrays.stream(this.types).map(Util::getDebugName).collect(Collectors.joining(", "));
            lastErrorMessage = String.format("%s %s%s returned %s, which could not be converted to %s", new Object[]{this.type, descriptor, this.optionalArgs(arguments), this.toString(returnedValue), toClasses});
            if (!this.suppressErrors) {
                Skript.warning((String)lastErrorMessage);
            }
            return Util.newArray(this.superType, 0);
        }
        lastErrorMessage = null;
        lastError = null;
        T[] returnArray = Util.newArray(this.superType, 1);
        returnArray[0] = converted;
        return returnArray;
    }

    private String optionalArgs(Object ... arguments) {
        if (arguments.length == 0) {
            return " called without arguments";
        }
        return " called with (" + this.toString(arguments) + ")";
    }

    private String toString(Object ... arguments) {
        return Arrays.stream(arguments).map(arg -> String.format("%s (%s)", Classes.toString((Object)arg), Util.getDebugName(Util.getClass(arg)))).collect(Collectors.joining(", "));
    }

    private Descriptor getDescriptor(Event e) {
        if (this.isDynamic) {
            String desc = (String)this.dynamicDescriptor.getSingle(e);
            if (desc == null) {
                return null;
            }
            try {
                return Descriptor.parse(desc);
            }
            catch (ClassNotFoundException ex) {
                if (!this.suppressErrors) {
                    Skript.exception((Throwable)ex, (String[])new String[0]);
                }
                return null;
            }
        }
        return this.staticDescriptor;
    }

    private static Descriptor specifyDescriptor(Descriptor descriptor, Class<?> cls) {
        if (descriptor.getJavaClass() != null) {
            return descriptor;
        }
        return Descriptor.create(cls, descriptor.getIdentifier());
    }

    private Optional<MethodHandle> selectMethod(Descriptor descriptor, Object[] args) {
        return this.getCallSite(descriptor).stream().filter(mh -> ExprJavaCall.matchesArgs(args, mh)).findFirst();
    }

    private static boolean matchesArgs(Object[] args, MethodHandle mh) {
        MethodType mt = mh.type();
        if (mt.parameterCount() != args.length && !mh.isVarargsCollector()) {
            return false;
        }
        Class<?>[] params = mt.parameterArray();
        for (int i = 0; !(i >= params.length || i == params.length - 1 && mh.isVarargsCollector()); ++i) {
            Class<?> param = params[i];
            Object[] arg = args[i];
            if (arg instanceof ArrayWrapper) {
                arg = ((ArrayWrapper)arg).getArray();
            }
            if (param.isInstance(arg) || arg instanceof Number && Util.NUMERIC_CLASSES.contains(param) || param.isPrimitive() && Util.WRAPPER_CLASSES.get(param).isInstance(arg) || arg instanceof String && (param == Character.TYPE || param == Character.class) && ((String)arg).length() == 1 || param == Class.class && (arg instanceof JavaType || arg instanceof ClassInfo) || !param.isPrimitive() && arg instanceof Null) continue;
            return false;
        }
        return true;
    }

    private static void convertTypes(MethodType mt, Object[] args) {
        Class<?>[] params = mt.parameterArray();
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            if (args[i] instanceof ArrayWrapper) {
                args[i] = ((ArrayWrapper)args[i]).getArray();
            }
            if (param.isPrimitive() && args[i] instanceof Number) {
                if (param == Byte.TYPE) {
                    args[i] = ((Number)args[i]).byteValue();
                } else if (param == Double.TYPE) {
                    args[i] = ((Number)args[i]).doubleValue();
                } else if (param == Float.TYPE) {
                    args[i] = Float.valueOf(((Number)args[i]).floatValue());
                } else if (param == Integer.TYPE) {
                    args[i] = ((Number)args[i]).intValue();
                } else if (param == Long.TYPE) {
                    args[i] = ((Number)args[i]).longValue();
                } else if (param == Short.TYPE) {
                    args[i] = ((Number)args[i]).shortValue();
                }
            }
            if (args[i] instanceof String && (param == Character.TYPE || param == Character.class)) {
                args[i] = Character.valueOf(((String)args[i]).charAt(0));
            }
            if (param == Class.class) {
                if (args[i] instanceof JavaType) {
                    args[i] = ((JavaType)args[i]).getJavaClass();
                } else if (args[i] instanceof ClassInfo) {
                    args[i] = ((ClassInfo)args[i]).getC();
                }
            }
            if (!(args[i] instanceof Null)) continue;
            args[i] = null;
        }
    }

    void setSuppressErrors(boolean suppressErrors) {
        this.suppressErrors = suppressErrors;
        if (this.targetArg instanceof ExprJavaCall) {
            ((ExprJavaCall)this.targetArg).setSuppressErrors(suppressErrors);
        }
    }

    public T getSingle(Event e) {
        T[] all = this.getArray(e);
        if (all.length == 0) {
            return null;
        }
        return all[0];
    }

    public T[] getArray(Event e) {
        return this.getAll(e);
    }

    public T[] getAll(Event e) {
        Object target = this.targetArg.getSingle(e);
        if (target == null) {
            return Util.newArray(this.superType, 0);
        }
        Object[] arguments = this.args != null ? (this.args instanceof ExpressionList ? Arrays.stream(((ExpressionList)this.args).getExpressions()).map(ExprJavaCall.unwrapExpression(e)).toArray(Object[]::new) : this.args.getArray(e)) : NO_ARGS;
        return this.invoke(target, arguments, this.getDescriptor(e));
    }

    private static Function<Expression, Object> unwrapExpression(Event e) {
        return expr -> {
            if (expr.isSingle()) {
                Object value = expr.getSingle(e);
                return value == null ? Null.getInstance() : value;
            }
            return expr.getArray(e);
        };
    }

    public boolean isSingle() {
        return true;
    }

    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return SimpleExpression.check((Object[])this.getAll(e), c, (boolean)negated, (boolean)this.getAnd());
    }

    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check((Object[])this.getAll(e), c, (boolean)false, (boolean)this.getAnd());
    }

    public <R> Expression<? extends R> getConvertedExpression(Class<R>[] to) {
        return new ExprJavaCall<R>(this, to);
    }

    public Class<T> getReturnType() {
        return this.superType;
    }

    public boolean getAnd() {
        return true;
    }

    public boolean setTime(int time) {
        return false;
    }

    public int getTime() {
        return 0;
    }

    public boolean isDefault() {
        return false;
    }

    public Iterator<? extends T> iterator(Event e) {
        return new ArrayIterator((Object[])this.getAll(e));
    }

    public boolean isLoopOf(String s) {
        return false;
    }

    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    public Expression<? extends T> simplify() {
        return this;
    }

    public String toString(Event e, boolean debug) {
        Descriptor descriptor = this.getDescriptor(e);
        if (descriptor == null) {
            return "java call";
        }
        return descriptor.toString();
    }

    public String toString() {
        return this.toString(null, false);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.type == Type.FIELD && (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE)) {
            return new Class[]{Object.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Object target = this.targetArg.getSingle(e);
        if (target == null) {
            return;
        }
        Object[] args = new Object[1];
        switch (mode) {
            case SET: {
                args[0] = delta[0];
                break;
            }
            case DELETE: {
                args[0] = Null.getInstance();
            }
        }
        this.invoke(target, args, this.getDescriptor(e));
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.targetArg = Util.defendExpression(exprs[0]);
        this.args = Util.defendExpression(exprs[matchedPattern == 0 ? 2 : 1]);
        if (!Util.canInitSafely(this.targetArg, this.args)) {
            return false;
        }
        switch (matchedPattern) {
            case 0: {
                this.isDynamic = true;
                this.type = parseResult.mark == 0 ? Type.FIELD : Type.METHOD;
                this.dynamicDescriptor = exprs[1];
                break;
            }
            case 1: {
                this.isDynamic = false;
                this.type = parseResult.mark == 0 ? Type.FIELD : Type.METHOD;
                String desc = ((MatchResult)parseResult.regexes.get(0)).group();
                try {
                    this.staticDescriptor = Descriptor.parse(desc);
                    if (this.staticDescriptor == null) {
                        Skript.error((String)(desc + " is not a valid descriptor."));
                        return false;
                    }
                    if (this.staticDescriptor.getJavaClass() != null && this.getCallSite(this.staticDescriptor).size() == 0) {
                        Skript.error((String)(desc + " refers to a non-existent method/field."));
                        return false;
                    }
                    break;
                }
                catch (ClassNotFoundException e) {
                    Skript.error((String)(desc + " refers to a non-existent class."));
                    return false;
                }
            }
            case 2: {
                this.type = Type.CONSTRUCTOR;
                this.staticDescriptor = CONSTRUCTOR_DESCRIPTOR;
            }
        }
        return true;
    }

    static {
        Skript.registerExpression(ExprJavaCall.class, Object.class, (ExpressionType)ExpressionType.PATTERN_MATCHES_EVERYTHING, (String[])new String[]{"%object%..%string%(0\u00a6!|1\u00a6\\([%-objects%]\\))", "%object%.<[\\w$.\\[\\]]+>(0\u00a6!|1\u00a6\\([%-objects%]\\))", "[a] new %javatype%\\([%-objects%]\\)"});
    }

    private static enum Type {
        FIELD,
        METHOD,
        CONSTRUCTOR;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

