/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptmirror;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.log.HandlerList;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import com.btk5h.skriptmirror.ArrayWrapper;
import com.btk5h.skriptmirror.JavaType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public final class Util {
    public static final Map<Class<?>, Class<?>> WRAPPER_CLASSES = new HashMap();
    public static final Set<Class<?>> NUMERIC_CLASSES = new HashSet();
    public static final String IDENTIFIER = "[_a-zA-Z$][\\w$]*";
    public static final String PACKAGE = "(?:[_a-zA-Z$][\\w$]*\\.)*(?:[_a-zA-Z$][\\w$]*)";
    private static Field PATTERNS;
    private static Field PARAMETERS;
    private static Field HANDLERS;

    private Util() {
    }

    public static void setPatterns(SyntaxElementInfo<?> info, String[] patterns) {
        if (PATTERNS != null) {
            try {
                PATTERNS.set(info, patterns);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static Parameter<?>[] getParameters(Function function) {
        if (PARAMETERS != null) {
            try {
                return (Parameter[])PARAMETERS.get(function);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        throw new IllegalStateException();
    }

    public static Stream<Field> fields(Class<?> cls) {
        return Stream.concat(Arrays.stream(cls.getFields()), Arrays.stream(cls.getDeclaredFields()).filter(Util::notPublic));
    }

    public static Stream<Method> methods(Class<?> cls) {
        return Stream.concat(Arrays.stream(cls.getMethods()), Arrays.stream(cls.getDeclaredMethods()).filter(Util::notPublic));
    }

    public static Stream<Constructor> constructor(Class<?> cls) {
        return Arrays.stream(cls.getDeclaredConstructors());
    }

    public static String toGenericString(Member o) {
        if (o instanceof Field) {
            return ((Field)o).toGenericString();
        }
        if (o instanceof Method) {
            return ((Method)o).toGenericString();
        }
        if (o instanceof Constructor) {
            return ((Constructor)o).toGenericString();
        }
        return null;
    }

    public static boolean notPublic(Member m) {
        return !Modifier.isPublic(m.getModifiers());
    }

    public static String preprocessPattern(String pattern) {
        StringBuilder newPattern = new StringBuilder(pattern.length());
        String[] parts = pattern.split("%");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i % 2 == 0) {
                newPattern.append(part);
                continue;
            }
            if (part.startsWith("_")) {
                part = part.endsWith("s") ? "objects" : "object";
            }
            newPattern.append('%');
            newPattern.append(part);
            newPattern.append('%');
        }
        return newPattern.toString();
    }

    public static <T> Expression<T> defendExpression(Expression<?> expr) {
        if (expr instanceof UnparsedLiteral) {
            Literal parsed = ((UnparsedLiteral)expr).getConvertedExpression(new Class[]{Object.class});
            return parsed == null ? expr : parsed;
        }
        if (expr instanceof ExpressionList) {
            Expression[] exprs = ((ExpressionList)expr).getExpressions();
            for (int i = 0; i < exprs.length; ++i) {
                exprs[i] = Util.defendExpression(exprs[i]);
            }
        }
        return expr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasUnparsedLiteral(Expression<?> expr) {
        if (expr instanceof UnparsedLiteral) return true;
        if (!(expr instanceof ExpressionList)) return false;
        if (!Arrays.stream(((ExpressionList)expr).getExpressions()).anyMatch(UnparsedLiteral.class::isInstance)) return false;
        return true;
    }

    public static boolean canInitSafely(Expression<?> ... expressions) {
        return Arrays.stream(expressions).filter(Objects::nonNull).noneMatch(Util::hasUnparsedLiteral);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<List<TriggerItem>> getItemsFromNode(SectionNode node, String key) {
        Node subNode = node.get(key);
        if (!(subNode instanceof SectionNode)) {
            return Optional.empty();
        }
        RetainingLogHandler log = SkriptLogger.startRetainingLog();
        try {
            Optional<List<TriggerItem>> optional = Optional.of(ScriptLoader.loadItems((SectionNode)((SectionNode)subNode)));
            return optional;
        }
        finally {
            Util.printLog(log);
            ScriptLoader.deleteCurrentEvent();
        }
    }

    private static void printLog(RetainingLogHandler logger) {
        logger.stop();
        if (HANDLERS != null) {
            LogHandler nextHandler;
            HandlerList handler;
            try {
                handler = (HandlerList)HANDLERS.get(logger);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return;
            }
            Iterator handlers = handler.iterator();
            ArrayList<LogHandler> parseLogs = new ArrayList<LogHandler>();
            while (handlers.hasNext() && (nextHandler = (LogHandler)handlers.next()) instanceof ParseLogHandler) {
                parseLogs.add(nextHandler);
            }
            parseLogs.forEach(LogHandler::stop);
            SkriptLogger.logAll((Collection)logger.getLog());
        }
    }

    public static <T, R> java.util.function.Function<T, R> propagateErrors(ExceptionalFunction<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception e) {
                Skript.warning((String)String.format("skript-mirror encountered a %s: %s%nRun Skript with the verbosity 'very high' for the stack trace.", e.getClass().getSimpleName(), e.getMessage()));
                if (Skript.logVeryHigh()) {
                    StringWriter errors = new StringWriter();
                    e.printStackTrace(new PrintWriter(errors));
                    Skript.warning((String)errors.toString());
                }
                return null;
            }
        };
    }

    public static Class<?> toClass(Object o) {
        if (o instanceof JavaType) {
            return ((JavaType)o).getJavaClass();
        }
        return o.getClass();
    }

    public static <T> T[] newArray(Class<? extends T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static String getDebugName(Class<?> cls) {
        return Skript.logVeryHigh() ? cls.getName() : cls.getSimpleName();
    }

    public static void clearSectionNode(SectionNode node) {
        ArrayList subNodes = new ArrayList();
        node.forEach(subNodes::add);
        subNodes.forEach(Node::remove);
    }

    public static Class<?> getClass(Object o) {
        if (o instanceof ArrayWrapper) {
            return ((ArrayWrapper)o).getArray().getClass();
        }
        if (o == null) {
            return Object.class;
        }
        return o.getClass();
    }

    static {
        WRAPPER_CLASSES.put(Boolean.TYPE, Boolean.class);
        WRAPPER_CLASSES.put(Byte.TYPE, Byte.class);
        WRAPPER_CLASSES.put(Character.TYPE, Character.class);
        WRAPPER_CLASSES.put(Double.TYPE, Double.class);
        WRAPPER_CLASSES.put(Float.TYPE, Float.class);
        WRAPPER_CLASSES.put(Integer.TYPE, Integer.class);
        WRAPPER_CLASSES.put(Long.TYPE, Long.class);
        WRAPPER_CLASSES.put(Short.TYPE, Short.class);
        NUMERIC_CLASSES.add(Byte.TYPE);
        NUMERIC_CLASSES.add(Double.TYPE);
        NUMERIC_CLASSES.add(Float.TYPE);
        NUMERIC_CLASSES.add(Integer.TYPE);
        NUMERIC_CLASSES.add(Long.TYPE);
        NUMERIC_CLASSES.add(Short.TYPE);
        Field _FIELD = null;
        try {
            _FIELD = SyntaxElementInfo.class.getDeclaredField("patterns");
            _FIELD.setAccessible(true);
            PATTERNS = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's pattern info field could not be resolved. Custom syntax will not work.");
        }
        try {
            _FIELD = Function.class.getDeclaredField("parameters");
            _FIELD.setAccessible(true);
            PARAMETERS = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's parameters field could not be resolved. Class proxies will not work.");
        }
        try {
            _FIELD = SkriptLogger.class.getDeclaredField("handlers");
            _FIELD.setAccessible(true);
            HANDLERS = _FIELD;
        }
        catch (NoSuchFieldException e) {
            Skript.warning((String)"Skript's handlers field could not be resolved. Some Skript warnings may not be available.");
        }
    }

    @FunctionalInterface
    public static interface ExceptionalFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

