/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.skuared.util;

import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Functions;
import com.google.common.collect.Lists;
import com.google.common.math.BigIntegerMath;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import fr.syst3ms.skuared.Skuared;
import fr.syst3ms.skuared.expressions.ExprSkuaredError;
import fr.syst3ms.skuared.util.Associativity;
import fr.syst3ms.skuared.util.MathUtils;
import fr.syst3ms.skuared.util.Operator;
import fr.syst3ms.skuared.util.ReflectionUtils;
import fr.syst3ms.skuared.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Algorithms {
    @NotNull
    public static Pattern NAME_PATTERN = Pattern.compile("[A-Za-z][A-Za-z\\d]*");
    @NotNull
    public static String TOKEN_PATTERN = "(?i)(?:(?<=[^\\w]|^)[+-])?(?:0[0-7]+|0x[0-9a-f]+|0b[01]+|\\d+(?:\\.\\d+)?)|[()]|([^\\w ()])\\1*|[a-z_][a-z\\d]*";
    @NotNull
    private static Map<String, Operator<Number, Number, Number>> arithmeticOperators = new HashMap<String, Operator<Number, Number, Number>>();
    @NotNull
    private static Map<String, Number> constants = new HashMap<String, Number>();
    @NotNull
    private static Pattern binaryPattern = Pattern.compile("0[Bb][01]+");
    @NotNull
    private static Pattern hexPattern = Pattern.compile("0[Xx]\\p{XDigit}+");
    @NotNull
    private static Pattern octPattern = Pattern.compile("0[0-8]+");

    public static Map<String, Number> getConstants() {
        return constants;
    }

    public static void registerOperator(@NotNull String symbol, @NotNull BiFunction<Number, Number, Number> operation, @NotNull Associativity associativity, int precedence) {
        arithmeticOperators.put(symbol, new Operator<Number, Number, Number>(symbol, precedence, associativity, operation));
    }

    public static void registerConstant(@NotNull String id, Number value) {
        constants.put(id.toLowerCase(), value);
    }

    public static int levenshtein(@NotNull String s, @NotNull String t, boolean ignoreCase) {
        if (ignoreCase) {
            s = s.toLowerCase();
            t = t.toLowerCase();
        }
        if (s.length() == 0) {
            return t.length();
        }
        if (t.length() == 0) {
            return s.length();
        }
        if (s.charAt(0) == t.charAt(0)) {
            return Algorithms.levenshtein(s.substring(1), t.substring(1), ignoreCase);
        }
        int a = Algorithms.levenshtein(s.substring(1), t.substring(1), ignoreCase);
        int b = Algorithms.levenshtein(s, t.substring(1), ignoreCase);
        int c = Algorithms.levenshtein(s.substring(1), t, ignoreCase);
        if (a > b) {
            a = b;
        }
        if (a > c) {
            a = c;
        }
        return a + 1;
    }

    public static String soundex(String s) {
        if (s.isEmpty()) {
            ExprSkuaredError.lastError = "[Soundex] The input cannot be empty";
            return null;
        }
        if (s.contains(" ")) {
            ExprSkuaredError.lastError = "[Soundex] The input can't contain spaces";
            return null;
        }
        char[] x = s.toUpperCase().toCharArray();
        char firstLetter = x[0];
        block8: for (int i = 0; i < x.length; ++i) {
            switch (x[i]) {
                case 'B': 
                case 'F': 
                case 'P': 
                case 'V': {
                    x[i] = 49;
                    continue block8;
                }
                case 'C': 
                case 'G': 
                case 'J': 
                case 'K': 
                case 'Q': 
                case 'S': 
                case 'X': 
                case 'Z': {
                    x[i] = 50;
                    continue block8;
                }
                case 'D': 
                case 'T': {
                    x[i] = 51;
                    continue block8;
                }
                case 'L': {
                    x[i] = 52;
                    continue block8;
                }
                case 'M': 
                case 'N': {
                    x[i] = 53;
                    continue block8;
                }
                case 'R': {
                    x[i] = 54;
                    continue block8;
                }
                default: {
                    x[i] = 48;
                }
            }
        }
        String output = Character.toString(firstLetter);
        for (int i = 1; i < x.length; ++i) {
            if (x[i] == x[i - 1] || x[i] == '0') continue;
            output = output + x[i];
        }
        output = output + "0000";
        return output.substring(0, 4);
    }

    private static List<String> processImplicit(@NotNull String orig) {
        List<String> tokens = StringUtils.getAllMatches(orig.replace(" ", ""), TOKEN_PATTERN);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            String nextToken;
            String token = tokens.get(i);
            String string = nextToken = i + 1 < tokens.size() ? tokens.get(i + 1) : null;
            if (StringUtils.isNumeric(token) && (nextToken != null && NAME_PATTERN.matcher(nextToken).matches() || "(".equals(nextToken)) || ")".equals(token) && "(".equals(nextToken)) {
                sb.append(token).append("*");
                continue;
            }
            if (StringUtils.isNumeric(token) && nextToken != null && "!".equals(nextToken)) {
                Number n = StringUtils.parseNumber(token);
                BigInteger factorial = BigIntegerMath.factorial((int)n.intValue());
                sb.append(factorial.toString());
                ++i;
                continue;
            }
            sb.append(token);
        }
        return StringUtils.getAllMatches(sb.toString(), TOKEN_PATTERN);
    }

    @Nullable
    public static List<String> shuntingYard(@NotNull String orig) {
        return Algorithms.shuntingYard(Algorithms.processImplicit(orig));
    }

    @Nullable
    private static List<String> shuntingYard(@NotNull List<String> tokens) throws ArithmeticException {
        ArrayList<String> output = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        block0: for (int i = 0; i < tokens.size(); ++i) {
            Object c;
            String nextToken;
            String token = tokens.get(i);
            String string = nextToken = i + 1 < tokens.size() ? tokens.get(i + 1) : null;
            if (arithmeticOperators.containsKey(token)) {
                String top;
                Operator<Number, Number, Number> currentOp = arithmeticOperators.get(token);
                if (!stack.isEmpty() && arithmeticOperators.containsKey(top = (String)stack.peek())) {
                    while (!stack.isEmpty()) {
                        Operator<Number, Number, Number> op = arithmeticOperators.get(top);
                        if (currentOp == null || op == null) break;
                        if (currentOp.getAssociativity() == Associativity.LEFT) {
                            if (currentOp.getPrecedence() < op.getPrecedence()) break;
                            output.add((String)stack.pop());
                            continue;
                        }
                        if (currentOp.getPrecedence() <= op.getPrecedence()) break;
                        output.add((String)stack.pop());
                    }
                }
                stack.add(token);
                continue;
            }
            if (NAME_PATTERN.matcher(token).matches() && !"(".equals(nextToken)) {
                c = constants.get(token.toLowerCase());
                if (c == null) {
                    Algorithms.parseError("Unknown constant : " + token);
                    return null;
                }
                output.add(StringUtils.toString((Number)c));
                continue;
            }
            if (NAME_PATTERN.matcher(token).matches()) {
                Function func = Functions.getFunction((String)token);
                if (MathUtils.checkFunction(func)) {
                    stack.add(func.getName());
                    continue;
                }
                Algorithms.parseError("Unknown function : " + token);
                return null;
            }
            if (octPattern.matcher(token).matches()) {
                output.add(StringUtils.toString(StringUtils.parseOctal(token.substring(1))));
                continue;
            }
            if (StringUtils.isNumeric(token)) {
                output.add(token);
                continue;
            }
            if (hexPattern.matcher(token).matches()) {
                output.add(StringUtils.toString(StringUtils.parseHex(token.substring(2))));
                continue;
            }
            if (binaryPattern.matcher(token).matches()) {
                output.add(StringUtils.toString(StringUtils.parseBin(token.substring(2))));
                continue;
            }
            if (token.equals("(")) {
                stack.add("(");
                continue;
            }
            if (token.equals(")")) {
                if (stack.isEmpty()) continue;
                while (true) {
                    if (stack.isEmpty()) {
                        Algorithms.parseError("Mismatched parentheses");
                        return null;
                    }
                    String s = (String)stack.peek();
                    if (s.equals("(")) {
                        stack.pop();
                        if (stack.isEmpty() || !NAME_PATTERN.matcher((CharSequence)stack.peek()).matches()) continue block0;
                        output.add((String)stack.pop());
                        continue block0;
                    }
                    output.add((String)stack.pop());
                }
            }
            if (token.equals(",")) {
                while (true) {
                    if (stack.isEmpty()) {
                        Algorithms.parseError("Misplaced comma");
                        return null;
                    }
                    c = (String)stack.peek();
                    if (((String)c).equals("(") && NAME_PATTERN.matcher((CharSequence)stack.elementAt(stack.size() - 2)).matches()) continue block0;
                    output.add((String)stack.pop());
                }
            }
            Algorithms.parseError("Unknown operator : " + token);
            return null;
        }
        for (String s : Lists.reverse(stack)) {
            if (s.equals("(")) {
                Algorithms.parseError("Mismatched parentheses");
                return null;
            }
            output.add(s);
        }
        Algorithms.parseError(null);
        return output;
    }

    private static void parseError(@Nullable String error) {
        ExprSkuaredError.lastError = error != null ? "[Skuared parsing] " + error : null;
    }

    private static void evalError(@Nullable String error) {
        ExprSkuaredError.lastError = error != null ? "[Skuared evaluation] " + error : null;
    }

    @Nullable
    public static Number evaluate(@NotNull String expr) {
        return Algorithms.evaluateRpn(Algorithms.shuntingYard(expr));
    }

    @Nullable
    @Contract(value="null -> null")
    static Number evaluateRpn(@Nullable List<String> rpn) {
        if (rpn == null) {
            return null;
        }
        Stack<Number> stack = new Stack<Number>();
        for (String s : rpn) {
            int i;
            if (StringUtils.isNumeric(s)) {
                stack.push(StringUtils.parseNumber(s).doubleValue());
                continue;
            }
            if (arithmeticOperators.containsKey(s)) {
                Number a = (Number)stack.pop();
                Number b = (Number)stack.pop();
                Operator<Number, Number, Number> op = arithmeticOperators.get(s);
                stack.push(op.getOperation().apply(b, a));
                continue;
            }
            if (!NAME_PATTERN.matcher(s).matches()) continue;
            Function func = Functions.getFunction((String)s);
            assert (func != null);
            if (func.getMaxParameters() > 1 && !ReflectionUtils.isSingle(func.getParameter(0)) && func.getMaxParameters() != stack.size()) {
                Algorithms.evalError("Wrong number of parameters for the '" + func.getName() + "' function");
                return Double.NaN;
            }
            Object[][] params = new Number[func.getMaxParameters()][func.getMaxParameters()];
            if (func.getMaxParameters() == 1 && ReflectionUtils.isSingle(func.getParameter(0))) {
                for (i = 0; i < func.getMaxParameters(); ++i) {
                    params[0][i] = (Number)stack.pop();
                }
            } else {
                for (i = 0; i < func.getMaxParameters(); ++i) {
                    params[i][0] = (Number)stack.pop();
                }
            }
            if (func.getName().equals("tan") && params.length == 1 && ((Number)params[0][0]).intValue() == 90) {
                stack.push(Double.POSITIVE_INFINITY);
                continue;
            }
            stack.push(((Number[])func.execute(params))[0]);
        }
        Algorithms.evalError(null);
        return (Number)stack.pop();
    }

    public static String tokensToString(@NotNull List<String> list) {
        return list.stream().collect(Collectors.joining(" "));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendWolframApiRequest(String message) {
        URL apiUrl;
        String wolframID = Skuared.getInstance().getWolframId();
        if (wolframID == null) {
            ExprSkuaredError.lastError = "No valid WolframAlpha App ID was provided";
            return null;
        }
        try {
            String urlEncoded = URLEncoder.encode(message, "UTF-8");
            apiUrl = new URL(String.format("https://api.wolframalpha.com/v1/result?i=%s&appid=%s", urlEncoded, wolframID));
        }
        catch (UnsupportedEncodingException | MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(apiUrl.openStream()));){
            String string = in.readLine();
            return string;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendLimitRequest(String message) {
        URL apiUrl;
        String wolframID = Skuared.getInstance().getWolframId();
        if (wolframID == null) {
            ExprSkuaredError.lastError = "No valid WolframAlpha App ID was provided";
            return null;
        }
        try {
            String urlEncoded = URLEncoder.encode(message, "UTF-8");
            apiUrl = new URL(String.format("https://api.wolframalpha.com/v2/query?input=%s&output=JSON&appid=%s", urlEncoded, wolframID));
        }
        catch (UnsupportedEncodingException | MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(apiUrl.openStream()));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            String content = sb.toString();
            Gson gson = new Gson();
            JsonObject obj = (JsonObject)gson.fromJson(content, JsonObject.class);
            String limitResult = obj.getAsJsonObject("queryresult").getAsJsonArray("pods").get(0).getAsJsonObject().getAsJsonArray("subpods").get(0).getAsJsonObject().get("plaintext").getAsString();
            String string = limitResult.split("=")[1].trim();
            return string;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

