/*
 * Decompiled with CFR 0.152.
 */
package fr.syst3ms.skuared;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.registrations.Classes;
import fr.syst3ms.skuared.util.Algorithms;
import fr.syst3ms.skuared.util.Associativity;
import fr.syst3ms.skuared.util.MathUtils;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Skuared
extends JavaPlugin {
    private static Skuared instance;
    private SkriptAddon addon;
    private FileConfiguration config;
    private String wolframId = null;

    public static Skuared getInstance() {
        return instance;
    }

    public void onEnable() {
        this.startupChecks();
        this.getLogger().log(Level.INFO, "Starting up Skuared...");
        this.setupSyntax();
        this.setupConfig();
        this.getLogger().log(Level.INFO, "Successfully started up Skuared !");
    }

    public void onDisable() {
    }

    private void startupChecks() {
        if (instance == null) {
            instance = this;
        } else {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot create two instances of Skuared !");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        if (!Skript.isRunningMinecraft((int)1, (int)8)) {
            this.getLogger().log(Level.SEVERE, "Outdated minecraft version ! Please update to 1.8 or newer !");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        this.config = this.getConfig();
    }

    private void setupConfig() {
        this.saveDefaultConfig();
        String s = this.config.getString("wolfram-id");
        if (s.matches("[A-Z0-9]+-[A-Z0-9]+")) {
            this.wolframId = s;
        }
    }

    private void setupSyntax() {
        this.addon = Skript.registerAddon((JavaPlugin)this);
        this.getLogger().log(Level.INFO, "Registering Skuared's syntax !");
        try {
            this.getAddon().loadClasses("fr.syst3ms.skuared", new String[]{"expressions", "effects", "fr.syst3ms.skuared.util"});
            this.mathRegister();
            this.getLogger().log(Level.INFO, "Successfully registered Skuared's syntaxes !");
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Something went wrong while registering syntax, so some syntaxes may not work");
        }
    }

    private void mathRegister() {
        Functions.registerFunction((JavaFunction)new JavaFunction<Number>("or", new Parameter[]{new Parameter("a", Classes.getExactClassInfo(Number.class), true, null), new Parameter("b", Classes.getExactClassInfo(Number.class), true, null)}, Classes.getExactClassInfo(Number.class), true){

            @NotNull
            public Number[] execute(FunctionEvent functionEvent, Object[][] objects) {
                Number a = (Number)objects[0][0];
                Number b = (Number)objects[1][0];
                return new Number[]{a.longValue() | b.longValue()};
            }
        });
        Functions.registerFunction((JavaFunction)new JavaFunction<Number>("and", new Parameter[]{new Parameter("a", Classes.getExactClassInfo(Number.class), true, null), new Parameter("b", Classes.getExactClassInfo(Number.class), true, null)}, Classes.getExactClassInfo(Number.class), true){

            @NotNull
            public Number[] execute(FunctionEvent functionEvent, Object[][] objects) {
                Number a = (Number)objects[0][0];
                Number b = (Number)objects[1][0];
                return new Number[]{a.longValue() & b.longValue()};
            }
        });
        Functions.registerFunction((JavaFunction)new JavaFunction<Number>("xor", new Parameter[]{new Parameter("a", Classes.getExactClassInfo(Number.class), true, null), new Parameter("b", Classes.getExactClassInfo(Number.class), true, null)}, Classes.getExactClassInfo(Number.class), true){

            @NotNull
            public Number[] execute(FunctionEvent functionEvent, Object[][] objects) {
                Number a = (Number)objects[0][0];
                Number b = (Number)objects[1][0];
                return new Number[]{a.longValue() ^ b.longValue()};
            }
        });
        Functions.registerFunction((JavaFunction)new JavaFunction<Number>("nor", new Parameter[]{new Parameter("a", Classes.getExactClassInfo(Number.class), true, null), new Parameter("b", Classes.getExactClassInfo(Number.class), true, null)}, Classes.getExactClassInfo(Number.class), true){

            @NotNull
            public Number[] execute(FunctionEvent functionEvent, Object[][] objects) {
                Number a = (Number)objects[0][0];
                Number b = (Number)objects[1][0];
                return new Number[]{(a.longValue() | b.longValue()) ^ 0xFFFFFFFFFFFFFFFFL};
            }
        });
        Functions.registerFunction((JavaFunction)new JavaFunction<Number>("nand", new Parameter[]{new Parameter("a", Classes.getExactClassInfo(Number.class), true, null), new Parameter("b", Classes.getExactClassInfo(Number.class), true, null)}, Classes.getExactClassInfo(Number.class), true){

            @NotNull
            public Number[] execute(FunctionEvent functionEvent, Object[][] objects) {
                Number a = (Number)objects[0][0];
                Number b = (Number)objects[1][0];
                return new Number[]{a.longValue() & b.longValue() ^ 0xFFFFFFFFFFFFFFFFL};
            }
        });
        Functions.registerFunction((JavaFunction)new JavaFunction<Number>("nxor", new Parameter[]{new Parameter("a", Classes.getExactClassInfo(Number.class), true, null), new Parameter("b", Classes.getExactClassInfo(Number.class), true, null)}, Classes.getExactClassInfo(Number.class), true){

            @NotNull
            public Number[] execute(FunctionEvent functionEvent, Object[][] objects) {
                Number a = (Number)objects[0][0];
                Number b = (Number)objects[1][0];
                return new Number[]{a.longValue() ^ b.longValue() ^ 0xFFFFFFFFFFFFFFFFL};
            }
        });
        Functions.registerFunction((JavaFunction)new JavaFunction<Number>("gamma", new Parameter[]{new Parameter("x", Classes.getExactClassInfo(Number.class), true, null)}, Classes.getExactClassInfo(Number.class), true){

            public Number[] execute(FunctionEvent e, Object[][] objects) {
                Number x = (Number)objects[0][0];
                return new Number[]{MathUtils.gamma(x.doubleValue())};
            }
        });
        Functions.registerFunction((JavaFunction)new JavaFunction<Number>("factorial", new Parameter[]{new Parameter("x", Classes.getExactClassInfo(Number.class), true, null)}, Classes.getExactClassInfo(Number.class), true){

            public Number[] execute(FunctionEvent e, Object[][] objects) {
                Number x = (Number)objects[0][0];
                return new Number[]{MathUtils.gamma(x.doubleValue() + 1.0)};
            }
        });
        Algorithms.registerOperator(">>", MathUtils::shr, Associativity.LEFT, 4);
        Algorithms.registerOperator("<<", MathUtils::shl, Associativity.LEFT, 4);
        Algorithms.registerOperator(">>>", MathUtils::ushr, Associativity.LEFT, 4);
        Algorithms.registerOperator("+", MathUtils::plus, Associativity.LEFT, 3);
        Algorithms.registerOperator("-", MathUtils::minus, Associativity.LEFT, 3);
        Algorithms.registerOperator("*", MathUtils::times, Associativity.LEFT, 2);
        Algorithms.registerOperator("/", MathUtils::divide, Associativity.LEFT, 2);
        Algorithms.registerOperator("%", MathUtils::mod, Associativity.LEFT, 2);
        Algorithms.registerOperator("^", MathUtils::pow, Associativity.RIGHT, 1);
        Algorithms.registerConstant("pi", Math.PI);
        Algorithms.registerConstant("e", Math.E);
        Algorithms.registerConstant("nan", Double.NaN);
        Algorithms.registerConstant("Infinity", Double.POSITIVE_INFINITY);
        Algorithms.registerConstant("phi", MathUtils.PHI);
    }

    public SkriptAddon getAddon() {
        return this.addon;
    }

    public String getWolframId() {
        return this.wolframId;
    }
}

