/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptlogs.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import me.blueyescat.skriptlogs.util.LogEvt;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Logger Name")
@Description(value={"Returns the name of the logger in a log event. None if the logger name doesn't exist.", "If a plugin logs a message using its plugin logger this will be name of the plugin. i.e. '[<Plugin>] <message>'.", "In this case the logged message won't contain this '[Plugin]' prefix. So you can check if the logger name is a valid plugin somehow and merge it with the logged message."})
@Examples(value={"set {_loggerName} to the logger name"})
@Since(value="0.1.0")
public class ExprLoggerName
extends SimpleExpression<String> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return true;
    }

    protected String[] get(Event e) {
        String name = ((LogEvt)e).getLogEvent().getLoggerName();
        if (name.isEmpty()) {
            return null;
        }
        return (String[])CollectionUtils.array((Object[])new String[]{name});
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "logged message";
    }

    static {
        Skript.registerExpression(ExprLoggerName.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] logger name"});
    }
}

