/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptlogs;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import java.io.IOException;
import me.blueyescat.skriptlogs.util.LogAppender;
import me.blueyescat.skriptlogs.util.Metrics;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SkriptLogs
extends JavaPlugin {
    private static SkriptLogs instance;
    private static SkriptAddon addonInstance;

    public SkriptLogs() {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
    }

    public void onEnable() {
        if (!Skript.isAcceptRegistrations()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.getLogger().severe("skript-logs can't be loaded when the server is already loaded! Plugin is disabled.");
            return;
        }
        try {
            SkriptAddon addonInstance = Skript.registerAddon((JavaPlugin)this).setLanguageFileDirectory("lang");
            addonInstance.loadClasses("me.blueyescat.skriptlogs", new String[]{"skript"});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        new LogAppender().start();
        Metrics metrics = new Metrics(SkriptLogs.getInstance());
        metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> Skript.getInstance().getDescription().getVersion()));
        this.getLogger().info("Started metrics!");
        this.getLogger().info("Finished loading!");
    }

    public static SkriptAddon getAddonInstance() {
        if (addonInstance == null) {
            addonInstance = Skript.registerAddon((JavaPlugin)SkriptLogs.getInstance());
        }
        return addonInstance;
    }

    public static SkriptLogs getInstance() {
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }
}

