/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptlogs.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.StandardLevel;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Log Message")
@Description(value={"Logs a message with the given log level. The last pattern uses 'info' level."})
@Examples(value={"log a warning \"test\"", "log errors \"test\" and \"error\"", "send a fatal error \"test\" to the console", "print in \"test\""})
@Since(value="0.1.0")
public class EffLogMessage
extends Effect {
    private Expression<StandardLevel> logLevel;
    private Expression<String> messages;
    private boolean usedPrint;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        boolean bl = this.usedPrint = matchedPattern == 2;
        if (!this.usedPrint) {
            this.logLevel = exprs[0];
        }
        this.messages = exprs[this.usedPrint ? 0 : 1];
        return true;
    }

    protected void execute(Event e) {
        if (this.logLevel == null && !this.usedPrint || this.messages == null) {
            return;
        }
        Logger logger = LogManager.getRootLogger();
        Level level = this.usedPrint ? Level.INFO : Level.valueOf((String)((StandardLevel)this.logLevel.getSingle(e)).toString());
        for (String message : (String[])this.messages.getArray(e)) {
            logger.log(level, message);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.usedPrint) {
            return "print " + this.messages.toString(e, debug);
        }
        return "log " + this.logLevel.toString(e, debug) + " message " + this.messages.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffLogMessage.class, (String[])new String[]{"(log|print [in]) %loglevel% [[with [the]] message[s]] %strings%", "send %loglevel% [[with [the]] message[s]] %strings% to [the] console", "print [in] %strings%"});
    }
}

