/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptjson.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.btk5h.skriptjson.SkriptUtil;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class ExprJSONToString
extends SimpleExpression<String> {
    private VariableString var;
    private boolean isLocal;

    protected String[] get(Event e) {
        String var = this.var.toString(e).toLowerCase(Locale.ENGLISH);
        return new String[]{this.getTree(e, var.substring(0, var.length() - 1), false).toJSONString()};
    }

    private Object getVariable(Event e, String name) {
        Object val = Variables.getVariable((String)name, (Event)e, (boolean)this.isLocal);
        if (val == null) {
            return Variables.getVariable((String)((this.isLocal ? "_" : "") + name), (Event)e, (boolean)false);
        }
        return val;
    }

    private static boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        while (i < length) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Object getSubtree(Event e, String name) {
        JSONAware subtree;
        Object val = this.getVariable(e, name);
        if (val == null) {
            val = this.getTree(e, name + "::", false);
        } else if (val == Boolean.TRUE && (subtree = this.getTree(e, name + "::", true)) != null) {
            val = subtree;
        }
        return val;
    }

    private JSONAware getTree(Event e, String name, boolean nullable) {
        Map var = (Map)this.getVariable(e, name + "*");
        if (var == null) {
            return nullable ? null : new JSONObject();
        }
        Stream<String> keys = var.keySet().stream().filter(Objects::nonNull);
        if (var.keySet().stream().filter(Objects::nonNull).allMatch(ExprJSONToString::isInteger)) {
            JSONArray obj = new JSONArray();
            keys.forEach(key -> obj.add(this.getSubtree(e, name + key)));
            return obj;
        }
        JSONObject obj = new JSONObject();
        keys.forEach(key -> obj.put(key, this.getSubtree(e, name + key)));
        return obj;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return null;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Variable varExpr;
        Expression<?> expr = exprs[0];
        if (expr instanceof Variable && (varExpr = (Variable)expr).isList()) {
            this.var = SkriptUtil.getVariableName(varExpr);
            this.isLocal = varExpr.isLocal();
            return true;
        }
        Skript.error((String)(expr + " is not a list variable"));
        return false;
    }

    static {
        PropertyExpression.register(ExprJSONToString.class, String.class, (String)"[serialized] json (form|representation)", (String)"objects");
    }
}

