/*
 * Decompiled with CFR 0.152.
 */
package com.btk5h.skriptjson.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.btk5h.skriptjson.SkriptUtil;
import java.util.Locale;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class EffJSONToVariable
extends Effect {
    private Expression<String> json;
    private VariableString var;
    private boolean isLocal;

    protected void execute(Event e) {
        String json = (String)this.json.getSingle(e);
        String var = this.var.toString(e).toLowerCase(Locale.ENGLISH);
        if (json == null) {
            return;
        }
        try {
            Object parsed = new JSONParser().parse(json);
            this.mapFirst(e, var.substring(0, var.length() - 3), parsed);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
    }

    private void mapFirst(Event e, String name, Object obj) {
        if (obj instanceof JSONObject) {
            this.handleObject(e, name, (JSONObject)obj);
        } else if (obj instanceof JSONArray) {
            this.handleArray(e, name, (JSONArray)obj);
        } else {
            Variables.setVariable((String)name, (Object)obj, (Event)e, (boolean)this.isLocal);
        }
    }

    private void map(Event e, String name, Object obj) {
        if (obj instanceof JSONObject) {
            Variables.setVariable((String)name, (Object)true, (Event)e, (boolean)this.isLocal);
            this.handleObject(e, name, (JSONObject)obj);
        } else if (obj instanceof JSONArray) {
            Variables.setVariable((String)name, (Object)true, (Event)e, (boolean)this.isLocal);
            this.handleArray(e, name, (JSONArray)obj);
        } else {
            Variables.setVariable((String)name, (Object)obj, (Event)e, (boolean)this.isLocal);
        }
    }

    private void handleObject(Event e, String name, JSONObject obj) {
        obj.keySet().forEach(key -> this.map(e, name + "::" + key, obj.get(key)));
    }

    private void handleArray(Event e, String name, JSONArray obj) {
        for (int i = 0; i < obj.size(); ++i) {
            this.map(e, name + "::" + (i + 1), obj.get(i));
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.json.toString(e, debug) + " => " + this.var.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Variable varExpr;
        this.json = exprs[0];
        Expression<?> expr = exprs[1];
        if (expr instanceof Variable && (varExpr = (Variable)expr).isList()) {
            this.var = SkriptUtil.getVariableName(varExpr);
            this.isLocal = varExpr.isLocal();
            return true;
        }
        Skript.error((String)(expr + " is not a list variable"));
        return false;
    }

    static {
        Skript.registerEffect(EffJSONToVariable.class, (String[])new String[]{"(map|copy) [the] json [(of|from)] %string% to [the] [var[iable]] %objects%"});
    }
}

