/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import me.blueyescat.skriptholo.skript.effects.EffCreateHologram;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Last Created Hologram")
@Description(value={"Holds the hologram that was created most recently with the `Create Hologram` effect.", "Can be deleted using the `delete/clear` changer which means the hologram will be removed from the world and this expression will be empty."})
@Examples(value={"set {_holo} to the created hologram"})
@Since(value="1.0.0")
public class ExprLastCreatedHologram
extends SimpleExpression<Hologram> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return true;
    }

    protected Hologram[] get(Event e) {
        return (Hologram[])CollectionUtils.array((Object[])new Hologram[]{EffCreateHologram.lastCreated});
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Utils.deleteHologram(EffCreateHologram.lastCreated);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Hologram> getReturnType() {
        return Hologram.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the last created hologram";
    }

    static {
        Skript.registerExpression(ExprLastCreatedHologram.class, Hologram.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [last[ly]] [(created|spawned)] holo[gram]"});
    }
}

