/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Parent Hologram of Hologram Line")
@Description(value={"Returns the parent hologram of a hologram line."})
@Examples(value={"set {_holo} to parent hologram of {_line}"})
@Since(value="1.0.0")
public class ExprHologramLineParent
extends SimpleExpression<Hologram> {
    private Expression<HologramLine> lines;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.lines = exprs[0];
        return true;
    }

    protected Hologram[] get(Event e) {
        ArrayList<Hologram> holograms = new ArrayList<Hologram>();
        for (HologramLine line : (HologramLine[])this.lines.getArray(e)) {
            holograms.add(line.getParent());
        }
        return holograms.toArray(new Hologram[0]);
    }

    public boolean isSingle() {
        return this.lines.isSingle();
    }

    public Class<? extends Hologram> getReturnType() {
        return Hologram.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the parent hologram of " + this.lines.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprHologramLineParent.class, Hologram.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [parent[s]] holo[gram][s] of [holo[gram] line[s]] %hologramlines%", "%hologramlines%'[s] [parent[s]] holo[gram][s]"});
    }
}

