/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import me.blueyescat.skriptholo.SkriptHolo;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Following Hologram Offset")
@Description(value={"Returns offset (directions) of a following hologram. Can be set."})
@Examples(value={"delete offset of last holo", "set following offset of {_hologram} to 0.5 meters east and 2.5 meters above"})
@Since(value="1.0.0")
@RequiredPlugins(value={"ProtocolLib"})
public class ExprFollowingHologramOffset
extends SimpleExpression<Direction> {
    private Expression<Hologram> holograms;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Utils.hasPlugin("ProtocolLib")) {
            Skript.error((String)"The following hologram feature requires ProtocolLib");
            return false;
        }
        this.holograms = exprs[0];
        return true;
    }

    protected Direction[] get(Event e) {
        ArrayList<Direction> offsets = new ArrayList<Direction>();
        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
            if (!Utils.isFollowingHologram(holo)) continue;
            for (int entityID : SkriptHolo.followingHolograms.keySet()) {
                Map<Hologram, Direction[]> holoMap = SkriptHolo.followingHolograms.get(entityID);
                for (Map.Entry<Hologram, Direction[]> o : holoMap.entrySet()) {
                    Map.Entry<Hologram, Direction[]> entry = o;
                    if (!entry.getKey().equals(holo) || entry.getValue() == null) continue;
                    offsets.addAll(Arrays.asList(entry.getValue()));
                }
            }
        }
        return offsets.toArray(new Direction[0]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Direction[].class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
            if (!Utils.isFollowingHologram(holo)) continue;
            for (int entityID : SkriptHolo.followingHolograms.keySet()) {
                Map<Hologram, Direction[]> holoMap = SkriptHolo.followingHolograms.get(entityID);
                for (Map.Entry<Hologram, Direction[]> o : holoMap.entrySet()) {
                    Map.Entry<Hologram, Direction[]> entry = o;
                    if (!entry.getKey().equals(holo)) continue;
                    if (mode == Changer.ChangeMode.SET) {
                        Direction[] directions = new Direction[delta.length];
                        for (int i = 0; i < delta.length; ++i) {
                            directions[i] = (Direction)delta[i];
                        }
                        entry.setValue(directions);
                        continue;
                    }
                    entry.setValue(null);
                }
            }
        }
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Direction> getReturnType() {
        return Direction.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the offset of " + this.holograms.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprFollowingHologramOffset.class, Direction.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [following] offset[s] of [holo[gram][s]] %holograms%", "%holograms%'[s] [following] offset[s]"});
    }
}

