/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.blueyescat.skriptholo.SkriptHolo;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Followed Entity of Hologram")
@Description(value={"Returns the followed entity of a hologram. Use the `Following Hologram` effect to make an exiting hologram start/stop following an entity."})
@Examples(value={"kill the followed entity of last hologram", "set {_entities::*} to the entities followed by holograms {_list::*}"})
@Since(value="1.0.0")
public class ExprFollowedEntityByHologram
extends SimpleExpression<Entity> {
    private Expression<Hologram> holograms;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holograms = exprs[0];
        return true;
    }

    protected Entity[] get(Event e) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
            Iterator<Map.Entry<Entity, List<Hologram>>> iterator = SkriptHolo.followingHologramsEntities.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Entity, List<Hologram>> o;
                Map.Entry<Entity, List<Hologram>> entry = o = iterator.next();
                for (Hologram holo2 : entry.getValue()) {
                    if (!holo2.equals(holo)) continue;
                    entities.add(entry.getKey());
                }
            }
        }
        return entities.toArray(new Entity[0]);
    }

    public boolean isSingle() {
        return this.holograms.isSingle();
    }

    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the followed entity by " + this.holograms.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprFollowedEntityByHologram.class, Entity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] followed entit(y|ies) (of|by) [holo[gram][s]] %holograms%", "[the] entit(y|ies) followed by [holo[gram][s]] %holograms%"});
    }
}

