/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hologram Visibility")
@Description(value={"Changes visibility of a hologram for the given players or makes a hologram invisible/visible by default.Resetting hologram visibility means setting the visibility to the default value (visible if not changed)."})
@Examples(value={"hide the last created hologram from the player", "reveal holos {holograms::*} to {_players::*}", "reset the visibility of all holograms", "make the last holo invisible by default", "make all holograms visible by default"})
@Since(value="1.0.0")
@RequiredPlugins(value={"ProtocolLib"})
public class EffHologramVisibility
extends Effect {
    private Expression<Hologram> holograms;
    private Expression<Player> players;
    private Modes mode;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Utils.hasPlugin("ProtocolLib")) {
            Skript.error((String)"The hologram visibility feature requires ProtocolLib");
            return false;
        }
        switch (matchedPattern) {
            case 0: {
                this.mode = Modes.HIDE;
                break;
            }
            case 1: {
                this.mode = Modes.REVEAL;
                break;
            }
            case 2: {
                if (exprs[1] == null) {
                    this.mode = Modes.RESET_ALL;
                    break;
                }
                this.mode = Modes.RESET;
                break;
            }
            case 3: {
                this.mode = Modes.DEFAULT_INVISIBLE;
                break;
            }
            case 4: {
                this.mode = Modes.DEFAULT_VISIBLE;
            }
        }
        this.holograms = exprs[0];
        if (matchedPattern < 3) {
            this.players = exprs[1];
        }
        return true;
    }

    protected void execute(Event e) {
        switch (this.mode) {
            case HIDE: 
            case REVEAL: {
                for (Player player : (Player[])this.players.getArray(e)) {
                    for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
                        if (this.mode == Modes.REVEAL) {
                            holo.getVisibilityManager().showTo(player);
                            continue;
                        }
                        holo.getVisibilityManager().hideTo(player);
                    }
                }
                break;
            }
            case RESET: {
                for (Player player : (Player[])this.players.getArray(e)) {
                    for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
                        holo.getVisibilityManager().resetVisibility(player);
                    }
                }
                break;
            }
            case RESET_ALL: {
                for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
                    holo.getVisibilityManager().resetVisibilityAll();
                }
                break;
            }
            case DEFAULT_INVISIBLE: 
            case DEFAULT_VISIBLE: {
                for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
                    holo.getVisibilityManager().setVisibleByDefault(this.mode == Modes.DEFAULT_VISIBLE);
                }
                break;
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        switch (this.mode) {
            case HIDE: {
                return "hide " + this.holograms.toString(e, debug) + " from " + this.players.toString(e, debug);
            }
            case REVEAL: {
                return "show " + this.holograms.toString(e, debug) + " to " + this.players.toString(e, debug);
            }
            case RESET: 
            case RESET_ALL: {
                return "reset visibility of " + this.holograms.toString(e, debug) + (this.players != null ? "for " + this.players.toString(e, debug) : "");
            }
            case DEFAULT_INVISIBLE: 
            case DEFAULT_VISIBLE: {
                return "make " + this.holograms.toString(e, debug) + (this.mode == Modes.DEFAULT_INVISIBLE ? " in" : " ") + "visible by default";
            }
        }
        return null;
    }

    static {
        Skript.registerEffect(EffHologramVisibility.class, (String[])new String[]{"hide [holo[gram][s]] %holograms% (from|for) %players%", "reveal [holo[gram][s]] %holograms% (to|for|from) %players%", "reset [the] visibilit(y|ies) of [holo[gram][s]] %holograms% [for %-players%]", "(make|let) [holo[gram][s]] %holograms% (invisible|hidden) by default", "(make|let) [holo[gram][s]] %holograms% visible by default"});
    }

    private static enum Modes {
        HIDE,
        REVEAL,
        RESET,
        RESET_ALL,
        DEFAULT_INVISIBLE,
        DEFAULT_VISIBLE;

    }
}

