/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import me.blueyescat.skriptholo.FollowingHologramListeners;
import me.blueyescat.skriptholo.SkriptHolo;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Create Hologram")
@Description(value={"Creates a new hologram.", "", "Besides the `store in %variable%`, the `Last Created Hologram` expression can be used to get the created hologram."})
@Examples(value={"create a new hologram with line \"test\" and store in {test}", "create new holo with lines \"line 1\", \"line 2\" and \"line 3\"", "create new hologram with line \"test\" that follows player offset by direction 2.3 meters above", "spawn a holo with click-able line \"Click\" that follows the spawned entity with offset (1.75 meters above and 1 meter infront)", "create a hologram with lines \"&bDiamond Armor\" and every diamond armor and store it in {holograms::1}", "spawn hologram with touchable line stone at {_location}"})
@Since(value="1.0.0")
public class EffCreateHologram
extends Effect {
    @Nullable
    public static Hologram lastCreated = null;
    private Expression<?> lines;
    private Expression<Location> location;
    private Expression<Entity> entity;
    private Expression<Direction> offset;
    private Variable<?> variable;
    private boolean isFollowing;
    private boolean clickable;
    private boolean touchable;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.clickable = (parseResult.mark & 1) == 1;
        this.touchable = (parseResult.mark & 2) == 2;
        this.lines = exprs[0];
        if (matchedPattern == 0) {
            this.location = Direction.combine(exprs[1], exprs[2]);
        } else {
            if (!Utils.hasPlugin("ProtocolLib")) {
                Skript.error((String)"The following hologram feature requires ProtocolLib");
                return false;
            }
            this.isFollowing = true;
            this.entity = exprs[1];
            this.offset = exprs[2];
        }
        if (exprs[3] != null) {
            if (exprs[3] instanceof Variable) {
                this.variable = (Variable)exprs[3];
            } else {
                Skript.error((String)(exprs[3].toString() + " is not a variable"));
                return false;
            }
        }
        return true;
    }

    protected void execute(Event e) {
        Hologram holo;
        Location location = null;
        Entity entity = null;
        Direction[] offset = null;
        Object[] lines = null;
        if (this.lines != null && (lines = this.lines.getArray(e)).length == 0) {
            return;
        }
        if (!this.isFollowing) {
            location = (Location)this.location.getSingle(e);
            if (location == null) {
                return;
            }
        } else if (this.entity != null) {
            entity = (Entity)this.entity.getSingle(e);
            if (entity == null) {
                return;
            }
            if (this.offset != null) {
                offset = (Direction[])this.offset.getArray(e);
                if (offset.length == 0) {
                    return;
                }
                location = Utils.offsetLocation(entity.getLocation(), offset);
            } else {
                location = entity.getLocation();
            }
        }
        lastCreated = holo = HologramsAPI.createHologram((Plugin)SkriptHolo.getInstance(), (Location)location);
        if (lines != null) {
            for (Object line : lines) {
                TextLine addedLine;
                if (line instanceof String) {
                    addedLine = holo.appendTextLine((String)line);
                    if (!this.clickable) continue;
                    Utils.addTouchHandler((HologramLine)addedLine);
                    continue;
                }
                if (!(line instanceof ItemType)) continue;
                for (ItemStack item : ((ItemType)line).getItem().getAll()) {
                    addedLine = holo.appendItemLine(item);
                    if (this.clickable) {
                        Utils.addTouchHandler((HologramLine)addedLine);
                    }
                    if (!this.touchable) continue;
                    Utils.addPickupHandler((HologramLine)addedLine);
                }
            }
        }
        if (this.isFollowing) {
            assert (entity != null);
            Utils.makeHologramStartFollowing(holo, entity, offset);
            FollowingHologramListeners.start();
        }
        if (this.variable != null) {
            this.variable.change(e, CollectionUtils.array((Object[])new Hologram[]{holo}), this.variable.isList() ? Changer.ChangeMode.ADD : Changer.ChangeMode.SET);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        String interact = "";
        if (this.clickable && this.touchable) {
            interact = "interactive ";
        } else if (this.clickable) {
            interact = "click-able ";
        } else if (this.touchable) {
            interact = "touchable ";
        }
        if (!this.isFollowing) {
            return "create a hologram" + (this.lines != null ? " with " + interact + "lines " + this.lines.toString(e, debug) : "") + " " + this.location.toString(e, debug) + (this.variable != null ? " and store it in " + this.variable.toString(e, debug) : "");
        }
        return "create a hologram" + (this.lines != null ? " with " + interact + "lines " + this.lines.toString(e, debug) : "") + " that follows " + this.entity.toString(e, debug) + (this.offset != null ? " with offset " + this.offset.toString(e, debug) : "") + (this.variable != null ? " and store it in " + this.variable.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffCreateHologram.class, (String[])new String[]{"(create|spawn) [a] [new] holo[gram] [with [((1\u00a6click|2\u00a6touch|3\u00a6interact)[-]able|3\u00a6interactive)] line[s] %-strings/itemtypes%] [%direction% %location%] [and store [it] in [[the] variable] %-objects%]", "(create|spawn) [a] [new] holo[gram] [with [((1\u00a6click|2\u00a6touch|3\u00a6interact)[-]able|3\u00a6interactive)] line[s] %-strings/itemtypes%] that follows %entity% [[with] offset [(of|by|in|to)] [[the] direction] %-directions%] [and store [it] in [[the] variable] %-objects%]"});
    }
}

