/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Allow Placeholders in Hologram")
@Description(value={"Allows/disallows placeholders in a hologram. Disallowed by default."})
@Examples(value={"allow placeholders in the created hologram", "disable placeholders for {_hologram}", "enable the placeholders in the holo", "disallow placeholders in {_holograms::*}"})
@Since(value="1.0.0")
public class EffAllowPlaceholdersInHologram
extends Effect {
    private Expression<Hologram> holograms;
    private boolean allow;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holograms = exprs[0];
        this.allow = matchedPattern == 0;
        return true;
    }

    protected void execute(Event e) {
        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
            holo.setAllowPlaceholders(this.allow);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return (!this.allow ? "dis" : "") + "allow placeholders in " + this.holograms.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffAllowPlaceholdersInHologram.class, (String[])new String[]{"(allow|enable) [the] placeholders (in|for) [holo[gram][s]] %holograms%", "(disallow|disable) [the] placeholders (in|for) [holo[gram][s]] %holograms%"});
    }
}

