/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import java.util.ArrayList;
import me.blueyescat.skriptholo.SkriptHolo;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="All Holograms")
@Description(value={"Returns all the holograms created by skript-holo or other plugins *except HolographicDisplays*."})
@Examples(value={"loop all holograms:"})
@Since(value="1.0.0")
public class ExprHolograms
extends SimpleExpression<Hologram> {
    private Expression<String> plugins;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 1) {
            this.plugins = exprs[0];
        }
        return true;
    }

    protected Hologram[] get(Event e) {
        if (this.plugins == null) {
            return HologramsAPI.getHolograms((Plugin)SkriptHolo.getInstance()).toArray(new Hologram[0]);
        }
        ArrayList holograms = new ArrayList();
        for (String name : (String[])this.plugins.getArray(e)) {
            Plugin plugin = Utils.getPlugin(name);
            if (plugin == null) continue;
            holograms.addAll(HologramsAPI.getHolograms((Plugin)plugin));
        }
        return holograms.toArray(new Hologram[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Hologram> getReturnType() {
        return Hologram.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "all holograms created by " + (this.plugins != null ? this.plugins.toString(e, debug) : "skript-holo");
    }

    static {
        Skript.registerExpression(ExprHolograms.class, Hologram.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[all] [the] holo[gram]s [([created] by|of|under|from) skript-holo]", "[all] [the] holo[gram]s ([created] by|of|under|from) [the] [plugin[s]] %strings%"});
    }
}

