/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hologram Height")
@Description(value={"Returns the physical height of a hologram."})
@Examples(value={"set {_height} to height of holo {_hologram}"})
@Since(value="1.0.0")
public class ExprHologramHeight
extends SimpleExpression<Number> {
    private Expression<Hologram> holograms;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holograms = exprs[0];
        return true;
    }

    protected Number[] get(Event e) {
        ArrayList<Double> heights = new ArrayList<Double>();
        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
            heights.add(holo.getHeight());
        }
        return heights.toArray(new Number[0]);
    }

    public boolean isSingle() {
        return this.holograms.isSingle();
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the height of " + this.holograms.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprHologramHeight.class, Number.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] [physical] height[s] of [holo[gram][s]] %holograms%", "%holograms%'[s] [physical] height[s]"});
    }
}

