/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Date;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hologram Creation Date")
@Description(value={"Returns the creation date of a hologram."})
@Examples(value={"if difference between creation date of event-hologram and now is greater than a hour:"})
@Since(value="1.0.0")
public class ExprHologramCreationDate
extends SimpleExpression<Date> {
    private Expression<Hologram> holograms;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holograms = exprs[0];
        return true;
    }

    protected Date[] get(Event e) {
        ArrayList<Date> dates = new ArrayList<Date>();
        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
            dates.add(new Date(holo.getCreationTimestamp()));
        }
        return dates.toArray(new Date[0]);
    }

    public boolean isSingle() {
        return this.holograms.isSingle();
    }

    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the creation date of " + this.holograms.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprHologramCreationDate.class, Date.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] (creation|spawned) date[s] of [holo[gram][s]] %holograms%", "%holograms%'[s] (creation|spawned) date[s]"});
    }
}

