/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Add Hologram Line")
@Description(value={"Adds new lines to a hologram. `insert` means adding after the specified line and moving the next lines below."})
@Examples(value={"append a stone to {_holo}", "prepend \"<light green>Test\" to the created hologram", "insert lines \"&cRedstone\" and a redstone in holo at line 2", "insert every diamond armor into the hologram at the 5th line"})
@Since(value="1.0.0")
public class EffAddHologramLine
extends Effect {
    private Modes mode;
    private boolean clickable;
    private boolean touchable;
    private Expression<?> lines;
    private Expression<Hologram> holograms;
    private Expression<Number> line;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.mode = Modes.APPEND;
        } else if (matchedPattern == 1) {
            this.mode = Modes.PREPEND;
        } else if (matchedPattern >= 2) {
            this.mode = Modes.INSERT;
            this.line = exprs[2];
        }
        this.clickable = (parseResult.mark & 1) == 1;
        this.touchable = (parseResult.mark & 2) == 2;
        this.lines = exprs[0];
        this.holograms = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
            if (holo.isDeleted()) continue;
            int li = 0;
            if (this.mode == Modes.INSERT) {
                Number l = (Number)this.line.getSingle(e);
                if (l == null) {
                    return;
                }
                li = l.intValue();
                if (li < 0 || li > holo.size()) continue;
            }
            for (Object line : this.lines.getArray(e)) {
                TextLine addedLine = null;
                if (this.mode == Modes.PREPEND || this.mode == Modes.INSERT) {
                    if (this.mode == Modes.PREPEND) {
                        li = 0;
                    }
                    if (line instanceof String) {
                        addedLine = holo.insertTextLine(li++, (String)line);
                    } else if (line instanceof ItemType) {
                        for (ItemStack item : ((ItemType)line).getItem().getAll()) {
                            addedLine = holo.insertItemLine(li++, item);
                        }
                    }
                } else if (line instanceof String) {
                    addedLine = holo.appendTextLine((String)line);
                } else if (line instanceof ItemType) {
                    for (ItemStack item : ((ItemType)line).getItem().getAll()) {
                        addedLine = holo.appendItemLine(item);
                    }
                }
                if (this.clickable) {
                    Utils.addTouchHandler((HologramLine)addedLine);
                }
                if (!this.touchable) continue;
                Utils.addPickupHandler((HologramLine)addedLine);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        String interact = null;
        if (this.clickable && this.touchable) {
            interact = "interactive ";
        } else if (this.clickable) {
            interact = "click-able ";
        } else if (this.touchable) {
            interact = "touchable ";
        }
        if (this.mode == Modes.INSERT) {
            return "insert " + (interact != null ? interact + " lines" : "") + this.lines.toString(e, debug) + " into " + this.holograms.toString(e, debug) + " at line " + this.line.toString(e, debug);
        }
        return (this.mode == Modes.PREPEND ? "prepend " : "append ") + (interact != null ? interact + " lines" : "") + this.lines.toString(e, debug) + " to " + this.holograms.toString(e, debug) + " at line " + this.line.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffAddHologramLine.class, (String[])new String[]{"append [((1\u00a6click|2\u00a6touch|3\u00a6interact)[-]able|3\u00a6interactive)] [line[s]] %-strings/itemtypes% to [holo[gram][s]] %holograms%", "prepend [((1\u00a6click|2\u00a6touch|3\u00a6interact)[-]able|3\u00a6interactive)] [line[s]] %-strings/itemtypes% to [holo[gram][s]] %holograms%", "insert [((1\u00a6click|2\u00a6touch|3\u00a6interact)[-]able|3\u00a6interactive)] [line[s]] %-strings/itemtypes% in[to] [holo[gram][s]] %holograms% at line %number%", "insert [((1\u00a6click|2\u00a6touch|3\u00a6interact)[-]able|3\u00a6interactive)] [line[s]] %-strings/itemtypes% in[to] [holo[gram][s]] %holograms% at [the] %number%(st|nd|rd|th) line"});
    }

    private static enum Modes {
        APPEND,
        PREPEND,
        INSERT;

    }
}

