/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hologram Allows Placeholders")
@Description(value={"Checks whether the given hologram allows placeholders."})
@Examples(value={"if event-hologram allows placeholders:", "if placeholders in event-hologram are enabled:", "if hologram {_variable} disallows placeholders:", "if {_holo} doesn't allow placeholders:", "if placeholders for {_holograms::*} are disabled:"})
@Since(value="1.0.0")
public class CondHologramAllowsPlaceholders
extends Condition {
    private Expression<Hologram> holograms;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holograms = exprs[0];
        this.setNegated(matchedPattern > 1 ^ parseResult.mark == 1);
        return true;
    }

    public boolean check(Event e) {
        return this.holograms.check(e, Hologram::isAllowPlaceholders, this.isNegated());
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.holograms.toString(e, debug) + (this.isNegated() ? " dis" : " ") + "allows placeholders";
    }

    static {
        Skript.registerCondition(CondHologramAllowsPlaceholders.class, (String[])new String[]{"[holo[gram][s]] %holograms% (allow|1\u00a6disallow)[s] placeholders", "placeholders (in|for) [holo[gram][s]] %holograms% are (enabled|1\u00a6disabled)", "[holo[gram][s]] %holograms% (doesn't|does not|don't|do not) (allow|1\u00a6disallow) placeholders", "placeholders (in|for) [holo[gram][s]] %holograms% (aren't|are not) (enabled|1\u00a6disabled)"});
    }
}

