/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Can See Hologram")
@Description(value={"Checks whether the given players can see the given holograms. Use the `Hologram Visibility` effect to hide/show holograms."})
@Examples(value={"if holo {_variable} is hidden from the player:", "if all players can see holograms {_list::*}:", "if hologram {_holo} is not visible for {_player}:", "if the player can see the holo {holograms::1}:"})
@Since(value="1.0.0")
@RequiredPlugins(value={"ProtocolLib"})
public class CondCanSeeHologram
extends Condition {
    private Expression<Player> players;
    private Expression<Hologram> holograms;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Utils.hasPlugin("ProtocolLib")) {
            Skript.error((String)"The hologram visibility feature requires ProtocolLib");
            return false;
        }
        if (matchedPattern == 1 || matchedPattern == 3) {
            this.players = exprs[0];
            this.holograms = exprs[1];
        } else {
            this.players = exprs[1];
            this.holograms = exprs[0];
        }
        this.setNegated(matchedPattern > 1 ^ parseResult.mark == 1);
        return true;
    }

    public boolean check(Event e) {
        return this.players.check(e, player -> this.holograms.check(e, holo -> holo.getVisibilityManager().isVisibleTo(player)), this.isNegated());
    }

    public String toString(@Nullable Event e, boolean debug) {
        return this.players.toString(e, debug) + " can " + (this.isNegated() ? "not " : "") + "see" + this.holograms.toString(e, debug);
    }

    static {
        Skript.registerCondition(CondCanSeeHologram.class, (String[])new String[]{"[holo[gram][s]] %holograms% (is|are) (visible|1\u00a6(invisible|hidden)) (for|to|from) %players%", "%players% can see [holo[gram][s]] %holograms%", "[holo[gram][s]] %holograms% (is|are)(n't| not) (visible|1\u00a6(invisible|hidden)) (for|to|from) %players%", "%players% can('t| not) see [holo[gram][s]] %holograms%"});
    }
}

