/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Comparators;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import com.gmail.filoghost.holographicdisplays.api.line.ItemLine;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import java.util.ArrayList;
import me.blueyescat.skriptholo.skript.Types;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hologram Lines")
@Description(value={"Returns lines of a hologram. Can be changed, removing a text or an item means it will search lines that match exactly with the input and remove them.", "", "It is possible to create new lines using the `set` changer, for example if the hologram has 3 lines and you set line 5, the line 4 will be blank."})
@Examples(value={"loop lines of the last created hologram:", "\tif loop-hologram line is an item line:", "\t\tdelete loop-hologram line", "", "set line 5 of create hologram to \"test\""})
@Since(value="1.0.0")
public class ExprHologramLines
extends SimpleExpression<HologramLine> {
    private Expression<Hologram> holograms;
    private Expression<Number> line;
    private Kleenean firstLine = Kleenean.UNKNOWN;
    private boolean allLines;
    private boolean isSingle;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern <= 1) {
            this.holograms = exprs[0];
            this.allLines = true;
        } else if (matchedPattern <= 3) {
            this.line = exprs[0];
            this.holograms = exprs[1];
        } else {
            this.firstLine = Kleenean.get((parseResult.mark == 0 ? 1 : 0) != 0);
            this.holograms = exprs[0];
        }
        this.isSingle = !this.allLines && this.holograms.isSingle();
        return true;
    }

    protected HologramLine[] get(Event e) {
        ArrayList<HologramLine> lines = new ArrayList<HologramLine>();
        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
            int li;
            if (this.line == null) {
                if (this.firstLine.isUnknown()) {
                    lines.addAll(Utils.getHologramLines(holo));
                    continue;
                }
                int line = this.firstLine.isTrue() ? 0 : holo.size() - 1;
                lines.add(holo.getLine(line));
                continue;
            }
            Number line = (Number)this.line.getSingle(e);
            if (line == null || (li = line.intValue() - 1) < 0 || li >= holo.size()) continue;
            lines.add(holo.getLine(li));
        }
        return lines.toArray(new HologramLine[0]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.allLines) {
            switch (mode) {
                case ADD: 
                case REMOVE: 
                case REMOVE_ALL: 
                case SET: 
                case DELETE: 
                case RESET: {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{String[].class, ItemType[].class});
                }
            }
        } else if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class, ItemType.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        block29: {
            block28: {
                if (!this.allLines) break block28;
                switch (mode) {
                    case ADD: {
                        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
                            if (holo.isDeleted()) continue;
                            for (Object o : delta) {
                                if (o instanceof String) {
                                    holo.appendTextLine((String)o);
                                    continue;
                                }
                                for (ItemStack item : ((ItemType)o).getItem().getAll()) {
                                    holo.appendItemLine(item);
                                }
                            }
                        }
                        break block29;
                    }
                    case REMOVE: 
                    case REMOVE_ALL: {
                        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
                            if (holo.isDeleted()) continue;
                            for (int line = 0; line < holo.size(); ++line) {
                                HologramLine removedLine = holo.getLine(line);
                                for (Object o : delta) {
                                    if (o instanceof String) {
                                        if (!(removedLine instanceof TextLine) || !Comparators.compare((Object)((TextLine)removedLine).getText(), (Object)o).is(Comparator.Relation.EQUAL)) continue;
                                        removedLine.removeLine();
                                        continue;
                                    }
                                    if (!(removedLine instanceof ItemLine)) continue;
                                    for (ItemStack item : ((ItemType)o).getItem().getAll()) {
                                        if (!Comparators.compare((Object)((ItemLine)removedLine).getItemStack(), (Object)item).is(Comparator.Relation.EQUAL)) continue;
                                        removedLine.removeLine();
                                    }
                                }
                            }
                        }
                        break block29;
                    }
                    case SET: {
                        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
                            if (holo.isDeleted()) continue;
                            holo.clearLines();
                            for (Object o : delta) {
                                if (o instanceof String) {
                                    holo.appendTextLine((String)o);
                                    continue;
                                }
                                for (ItemStack item : ((ItemType)o).getItem().getAll()) {
                                    holo.appendItemLine(item);
                                }
                            }
                        }
                        break block29;
                    }
                    case DELETE: 
                    case RESET: {
                        for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
                            if (holo.isDeleted()) continue;
                            holo.clearLines();
                        }
                        break;
                    }
                }
                break block29;
            }
            if (mode == Changer.ChangeMode.SET && this.line != null) {
                Number line = (Number)this.line.getSingle(e);
                if (line != null) {
                    int li = line.intValue();
                    if (li <= 0) {
                        return;
                    }
                    for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
                        if (holo.isDeleted()) continue;
                        if (li > holo.size()) {
                            int size = holo.size();
                            for (int i = 0; i < li - 1 - size; ++i) {
                                holo.appendTextLine("");
                            }
                            Object o = delta[0];
                            if (o instanceof String) {
                                holo.appendTextLine((String)o);
                                continue;
                            }
                            holo.appendItemLine(((ItemType)o).getItem().getRandom());
                            continue;
                        }
                        Types.hologramLineChanger.change(CollectionUtils.array((Object[])new HologramLine[]{holo.getLine(li - 1)}), delta, Changer.ChangeMode.SET);
                    }
                }
            } else {
                Types.hologramLineChanger.change((Object[])this.get(e), delta, mode);
            }
        }
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Class<? extends HologramLine> getReturnType() {
        return HologramLine.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (this.allLines) {
            return "the lines of " + this.holograms.toString(e, debug);
        }
        if (this.line == null) {
            return "the " + (this.firstLine.isTrue() ? "first" : "last") + " line of " + this.holograms.toString(e, debug);
        }
        return "the line " + this.line.toString(e, debug) + " of " + this.holograms.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprHologramLines.class, HologramLine.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[all] [the] lines of [holo[gram][s]] %holograms%", "%holograms%'[s] [all] lines", "[the] line %number% of [holo[gram][s]] %holograms%", "[the] %number%(st|nd|rd|th) line[s] of [holo[gram][s]] %holograms%", "[the] (first|1\u00a6last) line[s] of [holo[gram][s]] %holograms%"});
    }
}

