/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import java.util.ArrayList;
import java.util.List;
import me.blueyescat.skriptholo.SkriptHolo;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Following Holograms of Entity")
@Description(value={"Returns the following holograms of an entity. Use the `Following Hologram` effect to make an exiting hologram start/stop following an entity."})
@Examples(value={"delete the following holograms of targeted entity", "set {_holograms::*} to all holograms that follows the player"})
@Since(value="1.0.0")
@RequiredPlugins(value={"ProtocolLib"})
public class ExprEntityFollowingHolograms
extends SimpleExpression<Hologram> {
    private Expression<Entity> entities;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Utils.hasPlugin("ProtocolLib")) {
            Skript.error((String)"The following hologram feature requires ProtocolLib");
            return false;
        }
        this.entities = exprs[0];
        return true;
    }

    protected Hologram[] get(Event e) {
        ArrayList<Hologram> holograms = new ArrayList<Hologram>();
        for (Entity entity : (Entity[])this.entities.getArray(e)) {
            List<Hologram> holoList = SkriptHolo.followingHologramsEntities.get(entity);
            if (holoList == null) continue;
            holograms.addAll(holoList);
        }
        return holograms.toArray(new Hologram[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Hologram> getReturnType() {
        return Hologram.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the holograms following " + this.entities.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprEntityFollowingHolograms.class, Hologram.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[all] [the] following holo[gram]s of %entities%", "[all] [the] holo[gram]s (following|that follows) %entities%"});
    }
}

