/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import me.blueyescat.skriptholo.Listeners;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Following Hologram")
@Description(value={"Makes a hologram start/stop following an entity."})
@Examples(value={"set {_directions::*} to 1.5 meters horizontally infront, 1 meter above and 0.5 meters right", "make the last created hologram follow player with offset {_directions::*}", "", "make all holograms stop following", "let hologram {variable} start following event-entity"})
@Since(value="1.0.0")
@RequiredPlugins(value={"ProtocolLib"})
public class EffFollowingHologram
extends Effect {
    private Expression<Hologram> holograms;
    private Expression<Entity> entity;
    private Expression<Direction> offset;
    private boolean negative;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Utils.hasPlugin("ProtocolLib")) {
            Skript.error((String)"The following hologram feature requires ProtocolLib");
            return false;
        }
        this.holograms = exprs[0];
        boolean bl = this.negative = matchedPattern == 1;
        if (!this.negative) {
            this.entity = exprs[1];
            this.offset = exprs[2];
        }
        return true;
    }

    protected void execute(Event e) {
        if (!this.negative) {
            Entity entity = null;
            if (this.entity != null && (entity = (Entity)this.entity.getSingle(e)) == null) {
                return;
            }
            for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
                if (Utils.isFollowingHologram(holo)) {
                    Utils.makeHologramStopFollowing(holo);
                }
                Direction[] offset = null;
                if (this.offset != null) {
                    offset = (Direction[])this.offset.getArray(e);
                }
                assert (entity != null);
                Utils.makeHologramStartFollowing(holo, entity, offset);
            }
            Listeners.start();
        } else {
            for (Hologram holo : (Hologram[])this.holograms.getArray(e)) {
                if (!Utils.isFollowingHologram(holo)) continue;
                Utils.makeHologramStopFollowing(holo);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (!this.negative) {
            return "make " + this.holograms.toString(e, debug) + " start following " + this.entity.toString(e, debug) + (this.offset != null ? " with offset " + this.offset.toString(e, debug) : "");
        }
        return "make " + this.holograms.toString(e, debug) + " stop following " + (this.entity != null ? this.entity.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(EffFollowingHologram.class, (String[])new String[]{"(make|let) [holo[gram][s]] %holograms% (start following|follow) %entity% [[with] offset [(of|by|in|to)] [[the] direction] %-directions%]", "(make|let) [holo[gram][s]] %holograms% (stop following|unfollow)"});
    }
}

