/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Delete Hologram")
@Description(value={"Deletes a hologram. The hologram type has the delete changer already, but this effect exists for variables. For example `delete {_holo}` would delete the variable but you can use `delete hologram {_holo}` to avoid that.", "", "When you delete a hologram that is stored in a variable, the hologram object will still exist in the variable but will not be usable. You should delete the variable too in this case."})
@Examples(value={"delete holo {_var}", "remove holograms {_holograms::*}"})
@Since(value="1.0.0")
public class EffDeleteHologram
extends Effect {
    private Expression<Hologram> holograms;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holograms = exprs[0];
        return true;
    }

    protected void execute(Event e) {
        Utils.deleteHologram((Hologram[])this.holograms.getArray(e));
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "delete " + this.holograms.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffDeleteHologram.class, (String[])new String[]{"(delete|remove|clear) holo[gram][s] %holograms%"});
    }
}

