/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import org.bukkit.entity.Entity;

@Name(value="Is Hologram Entity")
@Description(value={"Checks whether the given entity is a part of a hologram. It is not possible to get the hologram."})
@Examples(value={"if targeted entity is a part of a hologram:", "if {_entities::*} are hologram entities:"})
@Since(value="1.0.0")
public class CondIsHologramEntity
extends PropertyCondition<Entity> {
    public boolean check(Entity entity) {
        return HologramsAPI.isHologramEntity((Entity)entity);
    }

    public String getPropertyName() {
        return "part of a hologram";
    }

    static {
        CondIsHologramEntity.register(CondIsHologramEntity.class, (String)"[[a] part[s] of] [a] holo[gram] [entit(y|ies)]", (String)"entities");
    }
}

