/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.util.coll.CollectionUtils;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import com.gmail.filoghost.holographicdisplays.api.line.ItemLine;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import me.blueyescat.skriptholo.util.Utils;
import org.bukkit.Location;
import org.eclipse.jdt.annotation.Nullable;

public class Types {
    public static Changer<HologramLine> hologramLineChanger;

    static {
        Classes.registerClass((ClassInfo)new ClassInfo(Hologram.class, "hologram").user(new String[]{"holo(gram)?s?"}).name("Hologram").description(new String[]{"A HolographicDisplays hologram. Can be deleted using the `delete/clear` changer or can be reset using the `reset` changer. When you delete a hologram that is stored in a variable, the hologram object will still exist in the variable but will not be usable. You should delete the variable too in this case."}).since("1.0.0").changer((Changer)new Changer<Hologram>(){

            public Class<?>[] acceptChange(Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                    return (Class[])CollectionUtils.array((Object[])new Class[0]);
                }
                return null;
            }

            public void change(Hologram[] holograms, @Nullable Object[] delta, Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.DELETE) {
                    Utils.deleteHologram(holograms);
                } else {
                    for (Hologram holo : holograms) {
                        if (holo.isDeleted()) continue;
                        holo.clearLines();
                    }
                }
            }
        }).parser((Parser)new Parser<Hologram>(){

            public boolean canParse(ParseContext context) {
                return false;
            }

            public String toString(Hologram holo, int flags) {
                return "hologram";
            }

            public String toVariableNameString(Hologram holo) {
                return "hologram";
            }

            public String getVariableNamePattern() {
                return "\\S+";
            }
        }));
        Converters.registerConverter(Hologram.class, Location.class, Hologram::getLocation);
        hologramLineChanger = new Changer<HologramLine>(){

            public Class<?>[] acceptChange(Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.SET) {
                    return (Class[])CollectionUtils.array((Object[])new Class[]{String.class, ItemType.class});
                }
                return null;
            }

            public void change(HologramLine[] lines, @Nullable Object[] delta, Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                    for (HologramLine line : lines) {
                        line.removeLine();
                    }
                } else {
                    for (HologramLine line : lines) {
                        int i;
                        Hologram holo;
                        Object o = delta[0];
                        if (o instanceof String) {
                            if (line instanceof TextLine) {
                                ((TextLine)line).setText((String)o);
                                continue;
                            }
                            holo = line.getParent();
                            i = 0;
                            for (HologramLine l : Utils.getHologramLines(holo)) {
                                if (l.equals(line)) {
                                    line.removeLine();
                                    holo.insertTextLine(i, (String)o);
                                }
                                ++i;
                            }
                            continue;
                        }
                        if (line instanceof ItemLine) {
                            ((ItemLine)line).setItemStack(((ItemType)o).getItem().getRandom());
                            continue;
                        }
                        holo = line.getParent();
                        i = 0;
                        for (HologramLine l : Utils.getHologramLines(holo)) {
                            if (l.equals(line)) {
                                line.removeLine();
                                holo.insertItemLine(i, ((ItemType)o).getItem().getRandom());
                            }
                            ++i;
                        }
                    }
                }
            }
        };
        Classes.registerClass((ClassInfo)new ClassInfo(HologramLine.class, "hologramline").user(new String[]{"holo(gram)?( |-)?lines?"}).name("Hologram Line").description(new String[]{"A line of a HolographicDisplays hologram. Can be deleted using the 'delete/clear' changer.", "", "Has converters to `text`, `item type` and `number`. Converters mean that you can use this type like the converted types. For example you can do `give line 1 of hologram to player` and `if event-hologram-line is 5:`, but please note that getting line number of a hologram line will check every line of the hologram. You shouldn't make systems that relies on line numbers, but contents."}).since("1.0.0").changer(hologramLineChanger).parser((Parser)new Parser<HologramLine>(){

            public boolean canParse(ParseContext context) {
                return false;
            }

            public String toString(HologramLine line, int flags) {
                if (line instanceof ItemLine) {
                    return "hologram item line";
                }
                return "hologram line";
            }

            public String toVariableNameString(HologramLine line) {
                if (line instanceof ItemLine) {
                    return "hologram item line";
                }
                return "hologram line";
            }

            public String getVariableNamePattern() {
                return "\\S+";
            }
        }));
        Converters.registerConverter(TextLine.class, String.class, TextLine::getText);
        Converters.registerConverter(ItemLine.class, ItemType.class, line -> new ItemType(line.getItemStack()));
        Converters.registerConverter(HologramLine.class, Number.class, line -> {
            Hologram holo = line.getParent();
            for (int l = 0; l < holo.size(); ++l) {
                if (!holo.getLine(l).equals(line)) continue;
                return l + 1;
            }
            return null;
        });
    }
}

