/*
 * Decompiled with CFR 0.152.
 */
package me.blueyescat.skriptholo.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hologram Line Number")
@Description(value={"Returns the number of a hologram line. But please note that getting line number of a hologram line will check every line of the hologram. You shouldn't make systems that relies on line numbers, but contents."})
@Examples(value={"if line number of event-holo-line is 2:"})
@Since(value="1.0.0")
public class ExprHologramLineNumber
extends SimpleExpression<Number> {
    private Expression<HologramLine> lines;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.lines = exprs[0];
        return true;
    }

    protected Number[] get(Event e) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (HologramLine line : (HologramLine[])this.lines.getArray(e)) {
            Hologram holo = line.getParent();
            for (int l = 0; l < holo.size(); ++l) {
                if (!holo.getLine(l).equals(line)) continue;
                numbers.add(l + 1);
            }
        }
        return numbers.toArray(new Number[0]);
    }

    public boolean isSingle() {
        return this.lines.isSingle();
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the line number of " + this.lines.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprHologramLineNumber.class, Number.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] line number[s] of [holo[gram] line[s]] %hologramlines%", "%hologramlines%'[s] line number[s]"});
    }
}

